/*
 * Decompiled with CFR 0.152.
 */
package org.unidal.net;

import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;

public class Networks {
    public static IpHelper forIp() {
        return IpHelper.INSTANCE;
    }

    public static void main(String[] args) {
        System.out.println("IP address selected: " + new IpHelper(true).getLocalHostAddress());
    }

    public static class IpHelper {
        private static IpHelper INSTANCE = new IpHelper(false);
        private InetAddress m_local;
        private boolean m_verbose;

        private IpHelper(boolean verbose) {
            this.m_verbose = verbose;
            this.initialize();
        }

        private String buildAddressFlags(InetAddress ia) {
            StringBuilder sb = new StringBuilder(64);
            try {
                if (ia.isAnyLocalAddress()) {
                    sb.append(",ANY");
                }
                if (ia.isLinkLocalAddress()) {
                    sb.append(",LINK");
                }
                if (ia.isLoopbackAddress()) {
                    sb.append(",LOOPBACK");
                }
                if (ia.isSiteLocalAddress()) {
                    sb.append(",SITE");
                }
                if (ia.isMulticastAddress()) {
                    sb.append(",MULTICAST");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (sb.length() > 0) {
                return sb.substring(1);
            }
            return "";
        }

        private String buildInterfaceFlags(NetworkInterface ni) {
            StringBuilder sb = new StringBuilder(64);
            try {
                if (ni.isUp()) {
                    sb.append(",UP");
                }
                if (ni.isLoopback()) {
                    sb.append(",LOOPBACK");
                }
                if (ni.isPointToPoint()) {
                    sb.append(",P2P");
                }
                if (ni.isVirtual()) {
                    sb.append(",VIRTUAL");
                }
                if (ni.supportsMulticast()) {
                    sb.append(",MULTICAST");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            if (sb.length() > 0) {
                return sb.substring(1);
            }
            return "";
        }

        private InetAddress getConfiguredAddress() {
            String ip = System.getProperty("host.ip");
            this.print("Checking IP address from property(host.ip) ... ", new Object[0]);
            if (ip != null) {
                this.println("Found " + ip, new Object[0]);
            } else {
                this.println(null, new Object[0]);
            }
            if (ip == null) {
                this.print("Checking IP address from env(HOST_IP) ... ", new Object[0]);
                ip = System.getenv("HOST_IP");
                if (ip != null) {
                    this.println("Found " + ip, new Object[0]);
                } else {
                    this.println(null, new Object[0]);
                }
            }
            if (ip != null) {
                try {
                    return InetAddress.getByName(ip);
                }
                catch (Exception e) {
                    this.println("[WARN] Unable to resolve IP address(%s)! %s, IGNORED.", ip, e);
                }
            }
            return null;
        }

        private InetAddress getDetectedAddress() {
            try {
                ArrayList<NetworkInterface> nis = Collections.list(NetworkInterface.getNetworkInterfaces());
                InetAddress found = null;
                int maxIndex = 0;
                for (NetworkInterface ni : nis) {
                    this.println("%s: flags=<%s> mtu %s", ni.getDisplayName(), this.buildInterfaceFlags(ni), ni.getMTU());
                    try {
                        ArrayList<InetAddress> ias = Collections.list(ni.getInetAddresses());
                        for (InetAddress ia : ias) {
                            boolean inet4 = ia instanceof Inet4Address;
                            int index = this.getIndex(ni, ia, inet4);
                            String address = ia.getHostAddress();
                            String flags = this.buildAddressFlags(ia);
                            this.println("     %s %s flags=<%s> index=%s", inet4 ? "inet" : "inet6", address, flags, index);
                            if (index <= maxIndex) continue;
                            found = ia;
                            maxIndex = index;
                        }
                    }
                    catch (Exception e) {
                        System.err.println(e);
                    }
                }
                return found;
            }
            catch (SocketException e) {
                this.println("[ERROR] %s", e);
                return null;
            }
        }

        private int getIndex(NetworkInterface ni, InetAddress ia, boolean inet4) {
            int index = 0;
            try {
                if (ni.isUp()) {
                    index += 8;
                }
                if (!ni.isVirtual()) {
                    index += 4;
                }
                if (!ni.isPointToPoint()) {
                    index += 2;
                }
                if (!ni.isLoopback()) {
                    ++index;
                }
                index <<= 4;
                if (ia.isSiteLocalAddress()) {
                    index += 8;
                }
                if (ia.isLinkLocalAddress()) {
                    index += 4;
                }
                if (!ia.isLoopbackAddress()) {
                    index += 2;
                }
                if (inet4) {
                    ++index;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return index;
        }

        public byte[] getLocalAddress() {
            return this.m_local.getAddress();
        }

        public String getLocalHostAddress() {
            return this.m_local.getHostAddress();
        }

        public String getLocalHostName() {
            try {
                return InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                return this.m_local.getHostName();
            }
        }

        private void initialize() {
            InetAddress address = this.getConfiguredAddress();
            if (address == null) {
                address = this.getDetectedAddress();
            }
            if (address == null) {
                throw new IllegalStateException("No IP address was detected!");
            }
            this.m_local = address;
        }

        private void print(String pattern, Object ... args) {
            if (this.m_verbose) {
                System.out.print(String.format(pattern, args));
            }
        }

        private void println(String pattern, Object ... args) {
            if (this.m_verbose) {
                if (pattern != null) {
                    System.out.println(String.format(pattern, args));
                } else {
                    System.out.println();
                }
            }
        }
    }
}

