/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.common.utils;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import java.security.MessageDigest;
import org.apache.commons.codec.binary.Base64;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MessageDigestUtils {
    private static Logger logger = LoggerFactory.getLogger(MessageDigestUtils.class);
    private MessageDigestUtils msgDigestUtils;

    public MessageDigestUtils getMessageDigestUtils() {
        if (this.msgDigestUtils == null) {
            this.msgDigestUtils = new MessageDigestUtils();
        }
        return this.msgDigestUtils;
    }

    public static String sha(String str) throws TuiaMediaException {
        return MessageDigestUtils.messageDigest(str, "SHA");
    }

    public static String md5(String str) throws TuiaMediaException {
        return MessageDigestUtils.messageDigest(str, "MD5");
    }

    private static String messageDigest(String str, String alg) throws TuiaMediaException {
        try {
            MessageDigest md = MessageDigest.getInstance(alg);
            md.update(str.getBytes("UTF-8"));
            Base64 bs = new Base64();
            return bs.encodeToString(md.digest());
        }
        catch (Exception e) {
            logger.error(" MessageDigestUtils messageDigest is error the e = [{}] ", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0001005.getErrorCode(), "\u7f16\u7801\u5f02\u5e38");
        }
    }
}

