/*
 * Decompiled with CFR 0.152.
 */
package com.taobao.top.link.embedded.websocket.auth;

import com.taobao.top.link.embedded.websocket.auth.AbstractAuthenticator;
import com.taobao.top.link.embedded.websocket.auth.AuthScheme;
import com.taobao.top.link.embedded.websocket.auth.Challenge;
import com.taobao.top.link.embedded.websocket.exception.ErrorCode;
import com.taobao.top.link.embedded.websocket.exception.WebSocketException;
import com.taobao.top.link.embedded.websocket.util.StringUtil;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DigestAuthenticator
extends AbstractAuthenticator {
    private Logger log = Logger.getLogger(DigestAuthenticator.class.getCanonicalName());

    @Override
    public String getCredentials(List<Challenge> challengeList) throws WebSocketException {
        for (Challenge challenge : challengeList) {
            if (!AuthScheme.Digest.equals((Object)challenge.getScheme())) continue;
            return this.getCredentials(challenge);
        }
        return null;
    }

    public String getCredentials(Challenge challenge) throws WebSocketException {
        String username = this.credentials.getUsername();
        String password = this.credentials.getPassword();
        String param = challenge.getParam();
        Map<String, String> paramMap = StringUtil.parseKeyValues(param, ',');
        String method = challenge.getMethod();
        String uri = challenge.getRequestUri();
        String opaque = paramMap.get("opaque");
        String nonce = paramMap.get("nonce");
        String qop = paramMap.get("qop");
        if (qop != null) {
            String[] qops = qop.split(",");
            if (qop.length() > 1) {
                for (int i = 0; i < qops.length; ++i) {
                    if (!"auth".equals(qops[i].trim())) continue;
                    qop = "auth";
                    break;
                }
            }
        }
        String realm = paramMap.get("realm");
        String algorithm = paramMap.get("algorithm");
        if (algorithm == null) {
            algorithm = "MD5";
        }
        String cnonce = this.generateCnonce();
        String nc = "00000001";
        StringBuilder sb = new StringBuilder(AuthScheme.Digest.name());
        sb.append(" ");
        StringUtil.addQuotedParam(sb, "username", username).append(", ");
        StringUtil.addQuotedParam(sb, "realm", realm).append(", ");
        StringUtil.addQuotedParam(sb, "nonce", nonce).append(", ");
        StringUtil.addQuotedParam(sb, "uri", uri).append(", ");
        if (qop != null) {
            StringUtil.addParam(sb, "qop", qop).append(", ");
            StringUtil.addParam(sb, "nc", nc).append(", ");
            StringUtil.addQuotedParam(sb, "cnonce", cnonce).append(", ");
        }
        String a1 = StringUtil.toMD5HexString(StringUtil.join(":", username, realm, password));
        if ("MD5-sess".equals(algorithm)) {
            a1 = StringUtil.toMD5HexString(StringUtil.join(":", a1, nonce, cnonce));
        }
        String a2 = null;
        if (qop != null && !"auth".equals(qop)) {
            if ("auth-int".equals(qop)) {
                throw new WebSocketException(ErrorCode.E3830);
            }
            throw new WebSocketException(ErrorCode.E3831, qop);
        }
        a2 = StringUtil.toMD5HexString(StringUtil.join(":", method, uri));
        String response = null;
        response = qop != null ? StringUtil.toMD5HexString(StringUtil.join(":", a1, nonce, nc, cnonce, qop, a2)) : StringUtil.toMD5HexString(StringUtil.join(":", a1, nonce, a2));
        if (opaque != null) {
            StringUtil.addQuotedParam(sb, "opaque", opaque).append(", ");
        }
        StringUtil.addQuotedParam(sb, "response", response);
        if (this.log.isLoggable(Level.FINER)) {
            this.log.finer(sb.toString() + "(, algorithm=" + algorithm + ", A1=" + a1 + ", A2=" + a2 + ")");
        }
        return sb.toString();
    }

    private String generateCnonce() {
        byte[] cnonceBytes = new byte[16];
        Random random = new Random();
        random.nextBytes(cnonceBytes);
        String cnonce = StringUtil.toHexString(cnonceBytes);
        return cnonce;
    }
}

