/*
 * Decompiled with CFR 0.152.
 */
package remoting.protocol.http;

import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import remoting.protocol.ProtocolStreamHandle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HttpProtocolHandle
extends ProtocolStreamHandle {
    private static byte[] HTTP_VERSION = "HTTP/1.1".getBytes();
    private static byte[] SPACE = " ".getBytes();
    private static byte[] HEADER_SEPARATOE = new byte[]{58, 32};
    private static byte[] END_OF_LINE = new byte[]{13, 10};

    public HttpProtocolHandle(ByteBuffer source) {
        super(source);
    }

    public String ReadFirstLine() {
        return this.ReadToEndOfLine();
    }

    public void WriteRequestFirstLine(String requestVerb, String url) {
        this.WriteBytes(requestVerb.getBytes());
        this.WriteByte((byte)32);
        this.WriteBytes(url.getBytes());
        this.WriteByte((byte)32);
        this.WriteBytes(HTTP_VERSION);
        this.WriteBytes(END_OF_LINE);
    }

    public void WriteResponseFirstLine(String httpStatusCode, String reasonPhrase) {
        this.WriteBytes(HTTP_VERSION);
        this.WriteBytes(SPACE);
        this.WriteBytes(httpStatusCode.getBytes());
        this.WriteByte((byte)32);
        this.WriteBytes(reasonPhrase.getBytes());
        this.WriteBytes(END_OF_LINE);
    }

    public HashMap<String, Object> ReadHeaders() {
        String header;
        HashMap<String, Object> dict = new HashMap<String, Object>();
        while ((header = this.ReadToEndOfLine()).length() != 0) {
            int sep = header.indexOf(":");
            String headerName = header.substring(0, sep);
            String headerValue = header.substring(sep + 1 + 1);
            dict.put(headerName, headerValue);
            if (!headerName.equalsIgnoreCase("Content-Length")) continue;
            this._contentLength = Integer.parseInt(headerValue);
        }
        return dict;
    }

    public void WriteHeaders(HashMap<String, Object> headers) {
        if (headers != null) {
            for (Map.Entry<String, Object> h : headers.entrySet()) {
                if (h.getKey().equalsIgnoreCase("Content-Length")) {
                    this._contentLength = Integer.parseInt(h.getValue().toString());
                }
                this.WriteHeader(h.getKey(), h.getValue().toString());
            }
        }
        this.WriteBytes(END_OF_LINE);
    }

    private void WriteHeader(String name, String value) {
        this.WriteBytes(name.getBytes());
        this.WriteBytes(HEADER_SEPARATOE);
        this.WriteBytes(value.getBytes());
        this.WriteBytes(END_OF_LINE);
    }

    private String ReadToEndOfLine() {
        String str = this.ReadToChar('\r');
        if (this.ReadByte() == 10) {
            return str;
        }
        return null;
    }

    private String ReadToChar(char value) {
        byte[] strBytes = this.ReadToByte((byte)value);
        if (strBytes == null) {
            return null;
        }
        if (strBytes.length == 0) {
            return "";
        }
        return new String(strBytes, Charset.forName("ASCII"));
    }

    private byte[] ReadToByte(byte b) {
        byte[] readBytes = new byte[]{};
        boolean find = false;
        while (!find) {
            byte read = (byte)this.ReadByte();
            find = read == b;
            if (find) continue;
            byte[] ret = new byte[readBytes.length + 1];
            System.arraycopy(readBytes, 0, ret, 0, readBytes.length);
            ret[ret.length - 1] = read;
            readBytes = ret;
        }
        return readBytes;
    }
}

