/*
 * Decompiled with CFR 0.152.
 */
package com.dianping.cat.configuration;

import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public enum NetworkInterfaceManager {
    INSTANCE;

    private InetAddress m_local;

    private NetworkInterfaceManager() {
        this.load();
    }

    public InetAddress findValidateIp(List<Address> addresses) {
        InetAddress local = null;
        int size = addresses.size();
        int maxWeight = -1;
        for (int i = 0; i < size; ++i) {
            Address address = addresses.get(i);
            int weight = 0;
            if (address.isSiteLocalAddress()) {
                weight += 8;
            }
            if (address.isLinkLocalAddress()) {
                weight += 4;
            }
            if (address.isLoopbackAddress()) {
                weight += 2;
            }
            if (address.hasHostName()) {
                ++weight;
            }
            if (weight <= maxWeight) continue;
            maxWeight = weight;
            local = address.getAddress();
        }
        return local;
    }

    public String getLocalHostAddress() {
        return this.m_local.getHostAddress();
    }

    public String getLocalHostName() {
        try {
            return InetAddress.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            return this.m_local.getHostName();
        }
    }

    private String getProperty(String name) {
        String value = null;
        value = System.getProperty(name);
        if (value == null) {
            value = System.getenv(name);
        }
        return value;
    }

    private void load() {
        String ip = this.getProperty("host.ip");
        if (ip != null) {
            try {
                this.m_local = InetAddress.getByName(ip);
                return;
            }
            catch (Exception e) {
                System.err.println(e);
            }
        }
        try {
            ArrayList<NetworkInterface> nis = Collections.list(NetworkInterface.getNetworkInterfaces());
            ArrayList<Address> addresses = new ArrayList<Address>();
            InetAddress local = null;
            try {
                for (NetworkInterface ni : nis) {
                    if (!ni.isUp()) continue;
                    ArrayList<InetAddress> list = Collections.list(ni.getInetAddresses());
                    for (InetAddress address : list) {
                        addresses.add(new Address(address, ni));
                    }
                }
                local = this.findValidateIp(addresses);
            }
            catch (Exception e) {
                // empty catch block
            }
            this.m_local = local;
        }
        catch (SocketException socketException) {
            // empty catch block
        }
    }

    static class Address {
        private InetAddress m_address;
        private boolean m_loopback;

        public Address(InetAddress address, NetworkInterface ni) {
            this.m_address = address;
            try {
                if (ni != null && ni.isLoopback()) {
                    this.m_loopback = true;
                }
            }
            catch (SocketException socketException) {
                // empty catch block
            }
        }

        public InetAddress getAddress() {
            return this.m_address;
        }

        public boolean hasHostName() {
            return !this.m_address.getHostName().equals(this.m_address.getHostAddress());
        }

        public boolean isLinkLocalAddress() {
            return !this.m_loopback && this.m_address.isLinkLocalAddress();
        }

        public boolean isLoopbackAddress() {
            return this.m_loopback || this.m_address.isLoopbackAddress();
        }

        public boolean isSiteLocalAddress() {
            return !this.m_loopback && this.m_address.isSiteLocalAddress();
        }
    }
}

