/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.web.controller;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySlotDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivitySlotDto;
import cn.com.duiba.tuia.media.domain.ActivitySortDto;
import cn.com.duiba.tuia.media.model.Result;
import cn.com.duiba.tuia.media.service.AccountService;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.tuia.media.service.ActivitySlotService;
import cn.com.duiba.tuia.media.service.ActivitySortService;
import cn.com.duiba.tuia.media.service.StrategyService;
import cn.com.duiba.tuia.media.service.impl.MediaCacheService;
import cn.com.duiba.tuia.media.service.impl.SlotCacheService;
import cn.com.duiba.tuia.media.utils.StringTool;
import cn.com.duiba.tuia.media.web.controller.BaseController;
import com.alibaba.dubbo.common.utils.StringUtils;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"/test"})
@Api(value="\u83b7\u53d6\u7f13\u5b58\u76f8\u5173api")
public class TestController
extends BaseController {
    @Autowired
    private MediaCacheService mediaCacheService;
    @Autowired
    private SlotCacheService slotCacheService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private StrategyService strategyService;
    @Autowired
    private ActivitySlotService activitySlotService;
    @Autowired
    private ActivitySortService activitySortService;
    @Autowired
    private AccountService accountService;

    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u5a92\u4f53\u540d\u79f0\u7f13\u5b58", httpMethod="GET", notes="\u83b7\u53d6\u5a92\u4f53\u540d\u79f0\u7f13\u5b58\u63a5\u53e3")
    @RequestMapping(value={"/getAppNameById"}, method={RequestMethod.GET})
    @ApiImplicitParam(name="appId", value="\u5a92\u4f53\u5e94\u7528ID", required=true, dataType="Long", paramType="query")
    public Result<String> getAppNameById(Long appId) {
        try {
            return this.successResult(this.mediaCacheService.getAppNameByIdKey(appId));
        }
        catch (Exception e) {
            this.logger.error("TestController.getAppNameById error!,the appId=[{}]", (Object)appId);
            return this.failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value="\u83b7\u53d6\u5e7f\u544a\u540d\u79f0\u7f13\u5b58", httpMethod="GET", notes="\u83b7\u53d6\u5e7f\u544a\u540d\u79f0\u7f13\u5b58\u63a5\u53e3")
    @RequestMapping(value={"/getSlotNameById"}, method={RequestMethod.GET})
    @ApiImplicitParam(name="slotId", value="\u5e7f\u544aID", required=true, dataType="Long", paramType="query")
    public Result<String> getSlotNameById(Long slotId) {
        try {
            return this.successResult(this.slotCacheService.getSlotNameCacheById(slotId));
        }
        catch (Exception e) {
            this.logger.error("TestController.getSlotNameById error!,the slotId=[{}]", (Object)slotId);
            return this.failResult(e);
        }
    }

    @ResponseBody
    @RequestMapping(value={"/cleanStrategyCache"}, method={RequestMethod.GET})
    public Result<Boolean> cleanStrategyCache(@RequestParam String ids) {
        try {
            List strategyIds = StringUtils.isBlank((String)ids) ? this.strategyService.selectAllIds() : StringTool.getLongListByStr((String)ids);
            this.logger.info("cleanStrategyCache begin!,the strategyIds=[{}]", (Object)strategyIds);
            if (CollectionUtils.isNotEmpty((Collection)strategyIds)) {
                for (Long strategyId : strategyIds) {
                    this.slotCacheService.deleteStrategyCache(strategyId.longValue());
                }
            }
            return this.successResult();
        }
        catch (Exception e) {
            this.logger.error("TestController.cleanStrategyCache error!,the slotId=[{}]", (Object)ids);
            return this.failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value="\u5220\u9664\u5a92\u4f53\u4fe1\u606f\u7f13\u5b58", httpMethod="POST", notes="\u5220\u9664\u5a92\u4f53\u4fe1\u606f\u7f13\u5b58")
    @RequestMapping(value={"/delAllAppCache"}, method={RequestMethod.POST})
    public Result<Boolean> delAllAppCache() {
        try {
            return this.successResult(this.mediaCacheService.delAllAppCache());
        }
        catch (Exception e) {
            this.logger.error("TestController.delAllAppCache error");
            return this.failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value="\u521d\u59cb\u5316\u5a92\u4f53\u4fe1\u606f\u7f13\u5b58", httpMethod="GET", notes="\u521d\u59cb\u5316\u5a92\u4f53\u4fe1\u606f\u7f13\u5b58")
    @RequestMapping(value={"/initAllAppCache"}, method={RequestMethod.GET})
    public Result<Boolean> initAllAppCache() {
        try {
            return this.successResult(this.mediaCacheService.initAllAppCache());
        }
        catch (Exception e) {
            this.logger.error("TestController.initAllAppCache error");
            return this.failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value="\u5220\u9664\u6240\u6709\u5a92\u4f53\u7528\u6237\u4fe1\u606f\u7f13\u5b58", httpMethod="POST", notes="\u5220\u9664\u6240\u6709\u5a92\u4f53\u7528\u6237\u4fe1\u606f\u7f13\u5b58")
    @RequestMapping(value={"/delAllAccountCache"}, method={RequestMethod.POST})
    public Result<Boolean> delAllAccountCache() {
        try {
            return this.successResult(this.mediaCacheService.delAllAccountCache());
        }
        catch (Exception e) {
            this.logger.error("TestController.delAllAccountCache error");
            return this.failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value="\u521d\u59cb\u5316\u6240\u6709\u5a92\u4f53\u7528\u6237\u4fe1\u606f\u7f13\u5b58", httpMethod="GET", notes="\u521d\u59cb\u5316\u6240\u6709\u5a92\u4f53\u7528\u6237\u4fe1\u606f\u7f13\u5b58")
    @RequestMapping(value={"/initAllAccountCache"}, method={RequestMethod.GET})
    public Result<Boolean> initAllAccountCache() {
        try {
            return this.successResult(this.mediaCacheService.initAllAccountCache());
        }
        catch (Exception e) {
            this.logger.error("TestController.initAllAccountCache error");
            return this.failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value="\u5237\u65b0\u6240\u6709\u6d3b\u52a8\u7f13\u5b58", httpMethod="GET", notes="\u5237\u65b0\u6240\u6709\u6d3b\u52a8\u7f13\u5b58")
    @RequestMapping(value={"/refreshAllRedisActivity"}, method={RequestMethod.GET})
    public Result<Boolean> refreshAllRedisActivity(@RequestParam String password) {
        try {
            if (!"abc123".equals(password)) {
                return this.successResult(false);
            }
            return this.successResult(this.mediaCacheService.refreshAllRedisActivity());
        }
        catch (Exception e) {
            this.logger.error("TestController.refreshAllRedisActivity error");
            return this.failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value="\u5237\u65b0\u6240\u6709appName\u548cId\u7f13\u5b58", httpMethod="GET", notes="\u5237\u65b0\u6240\u6709appName\u548cId\u7f13\u5b58")
    @RequestMapping(value={"/refreshAllAppNameAndId"}, method={RequestMethod.GET})
    public Result<Boolean> refreshAllAppNameAndId() {
        try {
            return this.successResult(this.mediaCacheService.getAppIdAndNameCache());
        }
        catch (Exception e) {
            this.logger.error("TestController.refreshAllAppNameAndId error");
            return this.failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value="\u5c06\u6240\u6709\u5f00\u542f\u6d3b\u52a8\u52a0\u5165\u5230\u624b\u52a8\u6295\u653e\u5217\u8868", httpMethod="GET", notes="\u5c06\u6240\u6709\u5f00\u542f\u6d3b\u52a8\u52a0\u5165\u5230\u624b\u52a8\u6295\u653e\u5217\u8868")
    @RequestMapping(value={"/addActivityToManualList"}, method={RequestMethod.GET})
    public Result<Boolean> addActivityToManualList(@RequestParam String password) {
        try {
            if (!"abc123".equals(password)) {
                return this.successResult(false);
            }
            return this.successResult(this.activityService.addActivityToManualList());
        }
        catch (Exception e) {
            this.logger.error("TestController.addActivityToManualList error");
            return this.failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value="\u66f4\u65b0\u6d3b\u52a8\u7edd\u5bf9\u6392\u5e8f\u5b57\u6bb5\u503c", httpMethod="GET", notes="\u66f4\u65b0\u6d3b\u52a8\u7edd\u5bf9\u6392\u5e8f\u5b57\u6bb5\u503c")
    @RequestMapping(value={"/updateActivitySort"}, method={RequestMethod.GET})
    public Result<Boolean> updateActivitySort(@RequestParam String password) {
        try {
            if (!"abc123".equals(password)) {
                return this.successResult(false);
            }
            ReqActivitySlotDto reqActivitySlotDto = new ReqActivitySlotDto();
            reqActivitySlotDto.setPageSize(Integer.valueOf(10000));
            reqActivitySlotDto.setCurrentPage(1);
            List activitySlotList = this.activitySlotService.getList(reqActivitySlotDto);
            for (RspActivitySlotDto activitySlotDto : activitySlotList) {
                List activitySortList = this.activitySortService.getBySlot(activitySlotDto.getSlotId());
                if (!CollectionUtils.isNotEmpty((Collection)activitySortList)) continue;
                for (int i = 0; i < activitySortList.size(); ++i) {
                    ActivitySortDto activitySortDto = (ActivitySortDto)activitySortList.get(i);
                    this.activitySortService.updateSort(activitySlotDto.getSlotId(), activitySortDto.getActivityId(), activitySortDto.getActivityType(), i + 1);
                }
            }
            List activitySortList = this.activitySortService.getBySlot(Long.valueOf(0L));
            if (CollectionUtils.isNotEmpty((Collection)activitySortList)) {
                for (int i = 0; i < activitySortList.size(); ++i) {
                    ActivitySortDto activitySortDto = (ActivitySortDto)activitySortList.get(i);
                    this.activitySortService.updateSort(Long.valueOf(0L), activitySortDto.getActivityId(), activitySortDto.getActivityType(), i + 1);
                }
            }
            return this.successResult(true);
        }
        catch (Exception e) {
            this.logger.error("TestController.updateActivitySort error");
            return this.failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value="\u4fee\u6539\u90ae\u7bb1\u6fc0\u6d3b\u72b6\u6001", httpMethod="POST", notes="\u4fee\u6539\u90ae\u7bb1\u6fc0\u6d3b\u72b6\u6001")
    @RequestMapping(value={"/updateEmailStatus"}, method={RequestMethod.POST})
    public Result<Boolean> updateEmailStatus(@RequestParam String email) {
        try {
            return this.successResult(this.accountService.manualUpdateEmailStatus(email));
        }
        catch (Exception e) {
            this.logger.error("TestController.updateEmailStatus error");
            return this.failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value="\u5237\u65b0\u6240\u6709\u5e7f\u544a\u4f4d\u5b9a\u5236\u6d3b\u52a8\u7f13\u5b58", httpMethod="GET", notes="\u5237\u65b0\u6240\u6709\u5e7f\u544a\u4f4d\u5b9a\u5236\u6d3b\u52a8\u7f13\u5b58")
    @RequestMapping(value={"/refreshAllRedisActivityDirectApp"}, method={RequestMethod.GET})
    public Result<Boolean> refreshAllRedisActivityDirectApp(@RequestParam Long activityId, @RequestParam Integer source) {
        try {
            return this.successResult(this.mediaCacheService.refreshAllRedisActivityDirectApp(activityId, source));
        }
        catch (Exception e) {
            this.logger.error("TestController.updateEmailStatus error");
            return this.failResult(e);
        }
    }
}

