/*
 * Decompiled with CFR 0.152.
 */
package springfox.documentation.spring.web.paths;

import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Predicate;
import com.google.common.collect.FluentIterable;
import java.util.Set;
import org.springframework.core.annotation.Order;
import org.springframework.stereotype.Component;
import springfox.documentation.service.Parameter;
import springfox.documentation.service.PathDecorator;
import springfox.documentation.spi.service.contexts.DocumentationContext;
import springfox.documentation.spi.service.contexts.PathContext;

@Component
@Order(value=-2147483588)
class QueryStringUriTemplateDecorator
implements PathDecorator {
    QueryStringUriTemplateDecorator() {
    }

    public Function<String, String> decorator(final PathContext context) {
        return new Function<String, String>(){

            public String apply(String input) {
                Set expressions = QueryStringUriTemplateDecorator.this.queryParamNames(context);
                String prefix = QueryStringUriTemplateDecorator.this.requiresContinuation(input) ? "{&" : "{?";
                String queryTemplate = Joiner.on((char)',').join((Iterable)expressions);
                if (queryTemplate.length() == 0) {
                    return input;
                }
                return String.format("%s%s%s}", input, prefix, queryTemplate);
            }
        };
    }

    private boolean requiresContinuation(String url) {
        return url.contains("?");
    }

    private Set<String> queryParamNames(PathContext context) {
        return FluentIterable.from((Iterable)context.getParameters()).filter(this.queryStringParams()).transform(this.paramName()).toSet();
    }

    private Predicate<Parameter> queryStringParams() {
        return new Predicate<Parameter>(){

            public boolean apply(Parameter input) {
                return "query".equals(input.getParamType());
            }
        };
    }

    private Function<Parameter, String> paramName() {
        return new Function<Parameter, String>(){

            public String apply(Parameter input) {
                return input.getName();
            }
        };
    }

    public boolean supports(DocumentationContext delimiter) {
        return delimiter.isUriTemplatesEnabled();
    }
}

