/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.dao.impl;

import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityAdvertDAO;
import cn.com.duiba.tuia.media.dao.BaseDAO;
import cn.com.duiba.tuia.media.dataobject.ActivityAdvertDO;
import java.util.HashMap;
import java.util.List;
import org.springframework.stereotype.Repository;
import org.springframework.util.CollectionUtils;

@Repository(value="activityAdvertDAO")
public class ActivityAdvertDAOImpl
extends BaseDAO
implements ActivityAdvertDAO {
    @Override
    public int insertBatch(List<ActivityAdvertDO> list) throws TuiaMediaException {
        try {
            if (CollectionUtils.isEmpty(list)) {
                return 0;
            }
            return this.getSqlSession().insert(this.getStamentNameSpace("insertBatch"), list);
        }
        catch (Exception e) {
            this.logger.error("ActivityAdvertDAO.insertBatch happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int delete(Long activityId, Integer activityType) throws TuiaMediaException {
        try {
            HashMap<String, Number> map = new HashMap<String, Number>();
            map.put("activityId", activityId);
            map.put("activityType", activityType);
            return this.getSqlSession().delete(this.getStamentNameSpace("delete"), map);
        }
        catch (Exception e) {
            this.logger.error("ActivityAdvertDAO.delete happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }

    @Override
    public int deleteBySource(Long activityId, Integer source) throws TuiaMediaException {
        try {
            HashMap<String, Number> map = new HashMap<String, Number>();
            map.put("activityId", activityId);
            map.put("source", source);
            return this.getSqlSession().delete(this.getStamentNameSpace("delete"), map);
        }
        catch (Exception e) {
            this.logger.error("ActivityAdvertDAO.delete happen [DB] error!", (Throwable)e);
            throw new TuiaMediaException(ErrorCode.E0002001, (Throwable)e);
        }
    }
}

