/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.remoteservice;

import cn.com.duiba.tuia.media.api.dto.MediaAppDataDto;
import cn.com.duiba.tuia.media.api.dto.SlotCacheDto;
import cn.com.duiba.tuia.media.api.dto.SlotCfgCacheDto;
import cn.com.duiba.tuia.media.api.dto.StrategyCacheDto;
import cn.com.duiba.tuia.media.api.remoteservice.RemoteMediaService;
import cn.com.duiba.tuia.media.remoteservice.BaseRemoteService;
import cn.com.duiba.tuia.media.service.impl.MediaCacheService;
import cn.com.duiba.tuia.media.service.impl.SlotCacheService;
import cn.com.duiba.wolf.dubbo.DubboResult;
import org.springframework.beans.factory.annotation.Autowired;

public class RemoteMediaServiceImpl
extends BaseRemoteService
implements RemoteMediaService {
    @Autowired
    private MediaCacheService mediaCacheService;
    @Autowired
    private SlotCacheService slotCacheService;

    public DubboResult<StrategyCacheDto> getStrategy(long slotId) {
        try {
            return DubboResult.successResult((Object)this.slotCacheService.getStrategy(slotId));
        }
        catch (Exception e) {
            this.logger.error("RemoteMediaService.getStrategy is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<Boolean> isValidMediaApp(long mediaAppId) {
        try {
            return DubboResult.successResult((Object)this.mediaCacheService.isValidMediaApp(mediaAppId));
        }
        catch (Exception e) {
            this.logger.error("RemoteMediaService.isValidMediaApp is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<MediaAppDataDto> getMediaApp(long mediaAppId) {
        try {
            return DubboResult.successResult((Object)this.mediaCacheService.getMediaApp(mediaAppId));
        }
        catch (Exception e) {
            this.logger.error("RemoteMediaService.getMediaApp is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<SlotCacheDto> getSlot(long slotId) {
        try {
            return DubboResult.successResult((Object)this.slotCacheService.getSlot(slotId));
        }
        catch (Exception e) {
            this.logger.error("RemoteMediaService.getSlot is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<SlotCfgCacheDto> getSlotCfg(long slotId) {
        try {
            return DubboResult.successResult((Object)this.slotCacheService.getSlotCfg(slotId));
        }
        catch (Exception e) {
            this.logger.error("RemoteMediaService.getSlot is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<StrategyCacheDto> updateStrategy(long slotId) {
        try {
            return DubboResult.successResult((Object)this.slotCacheService.updateStrategy(slotId));
        }
        catch (Exception e) {
            this.logger.error("RemoteMediaService.updateStrategy is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<MediaAppDataDto> getMediaAppByKey(String appKey) {
        try {
            return DubboResult.successResult((Object)this.mediaCacheService.getMediaAppByKey(appKey));
        }
        catch (Exception e) {
            this.logger.error("RemoteMediaService.getMediaAppByKey is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<MediaAppDataDto> updateMediaAppByKey(String appKey) {
        try {
            return DubboResult.successResult((Object)this.mediaCacheService.updateMediaAppByKey(appKey));
        }
        catch (Exception e) {
            this.logger.error("RemoteMediaService.updateMediaAppByKey is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<StrategyCacheDto> updateStrategyById(long strategyId) {
        try {
            return DubboResult.successResult((Object)this.slotCacheService.updateStrategyById(strategyId));
        }
        catch (Exception e) {
            this.logger.error("RemoteMediaService.updateStrategyById is error");
            return this.exceptionFailure(e);
        }
    }

    public DubboResult<SlotCacheDto> updateSlot(long slotId) {
        try {
            return DubboResult.successResult((Object)this.slotCacheService.updateSlotById(slotId));
        }
        catch (Exception e) {
            this.logger.error("RemoteMediaService.updateSlot is error");
            return this.exceptionFailure(e);
        }
    }
}

