/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.dto.SlotDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySlotDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqCopySlot;
import cn.com.duiba.tuia.media.api.dto.req.ReqIdAndType;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivitySlotDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.common.utils.CollectionUtil;
import cn.com.duiba.tuia.media.dao.ActivitySlotDAO;
import cn.com.duiba.tuia.media.dao.ActivitySortDAO;
import cn.com.duiba.tuia.media.dao.MediaAppDao;
import cn.com.duiba.tuia.media.dao.SlotDAO;
import cn.com.duiba.tuia.media.dataobject.ActivitySlotDO;
import cn.com.duiba.tuia.media.dataobject.MaterialSpecificationDO;
import cn.com.duiba.tuia.media.domain.ActivitySortDto;
import cn.com.duiba.tuia.media.service.ActivitySlotService;
import cn.com.duiba.tuia.media.service.ActivitySortService;
import cn.com.duiba.tuia.media.service.MaterialSpecificationService;
import cn.com.duiba.tuia.media.service.impl.MediaCacheService;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="activitySlotService")
public class ActivitySlotServiceImpl
implements ActivitySlotService {
    @Autowired
    private ActivitySlotDAO activitySlotDAO;
    @Autowired
    private SlotDAO slotDAO;
    @Autowired
    private ActivitySortDAO activitySortDAO;
    @Autowired
    private MediaAppDao mediaAppDao;
    @Autowired
    private MediaCacheService mediaCacheService;
    @Autowired
    private MaterialSpecificationService materialSpecificationService;
    @Autowired
    private ActivitySortService activitySortService;

    @Override
    public Boolean addSlots(List<Long> slotIds) throws TuiaMediaException {
        if (CollectionUtils.isEmpty(slotIds)) {
            return true;
        }
        ArrayList<ActivitySlotDO> list = new ArrayList<ActivitySlotDO>(slotIds.size());
        for (Long slotId : slotIds) {
            ActivitySlotDO activitySlotDO = new ActivitySlotDO();
            activitySlotDO.setSlotId(slotId);
            if (this.activitySlotDAO.getBySlotId(slotId) != null) continue;
            list.add(activitySlotDO);
        }
        this.activitySlotDAO.insertBatch(list);
        return true;
    }

    @Override
    @Transactional
    public Boolean deleteSlot(Long slotId) throws TuiaMediaException {
        this.activitySlotDAO.delete(slotId);
        this.activitySortDAO.deleteAllSlotActivity(slotId);
        return true;
    }

    @Override
    public List<RspActivitySlotDto> getList(ReqActivitySlotDto req) throws TuiaMediaException {
        if (StringUtils.isNotEmpty((String)req.getName())) {
            List<Long> ids = this.slotDAO.selectIdsByName(req.getName());
            if (CollectionUtils.isEmpty(ids)) {
                return Lists.newArrayList();
            }
            req.setIdList(ids);
        }
        if (StringUtils.isNotBlank((String)req.getAppName())) {
            List<Long> appIds = this.mediaAppDao.selectIdsByName(req.getAppName());
            if (CollectionUtils.isEmpty(appIds)) {
                return Lists.newArrayList();
            }
            req.setAppIdList(appIds);
        }
        req.setSort("gmt_modified");
        req.setOrder("desc");
        req.setRowStart(req.getPageSize() * (req.getCurrentPage() - 1));
        List<RspActivitySlotDto> rspActivitySlotList = this.activitySlotDAO.getList(req);
        List<SlotDto> slotList = this.slotDAO.selectListDetail(CollectionUtil.getFieldList(rspActivitySlotList, (String)"slotId"));
        Map<Long, MaterialSpecificationDO> msMap = this.materialSpecificationService.getMapByIds(CollectionUtil.getFieldList(slotList, (String)"slotMsId"));
        for (RspActivitySlotDto activitySlotDto : rspActivitySlotList) {
            MaterialSpecificationDO ms;
            activitySlotDto.setAppName(this.mediaCacheService.getAppNameByIdKey(activitySlotDto.getAppId()));
            activitySlotDto.setMsName(SlotDto.getSlotTypeNameBySlotType((int)activitySlotDto.getSlotType()));
            if (activitySlotDto.getSlotMsId() == null || (ms = msMap.get(activitySlotDto.getSlotMsId())) == null) continue;
            activitySlotDto.setMsName(ms.getTitle());
        }
        return rspActivitySlotList;
    }

    @Override
    public int getListAmount(ReqActivitySlotDto req) throws TuiaMediaException {
        if (StringUtils.isNotEmpty((String)req.getName())) {
            List<Long> ids = this.slotDAO.selectIdsByName(req.getName());
            if (CollectionUtils.isEmpty(ids)) {
                return 0;
            }
            req.setIdList(ids);
        }
        if (StringUtils.isNotBlank((String)req.getAppName())) {
            List<Long> appIds = this.mediaAppDao.selectIdsByName(req.getAppName());
            if (CollectionUtils.isEmpty(appIds)) {
                return 0;
            }
            req.setAppIdList(appIds);
        }
        return this.activitySlotDAO.getListAmount(req);
    }

    @Override
    public ActivitySlotDO getBySlotId(Long slotId) throws TuiaMediaException {
        return this.activitySlotDAO.getBySlotId(slotId);
    }

    @Override
    public Boolean updateDirectMode(Long slotId, Integer directMode) throws TuiaMediaException {
        if (1 != directMode && 2 != directMode) {
            return false;
        }
        return this.activitySlotDAO.update(slotId, directMode) == 1;
    }

    @Override
    public Boolean copySlot(ReqCopySlot req) throws TuiaMediaException {
        if (req.getParentSlotId() == req.getChildSlotId()) {
            throw new TuiaMediaException(ErrorCode.E0501005);
        }
        SlotDto slotDto = this.slotDAO.selectById(req.getChildSlotId());
        if (slotDto == null) {
            throw new TuiaMediaException(ErrorCode.E0304008);
        }
        ActivitySlotDO childActivitySlot = this.activitySlotDAO.getBySlotId(req.getChildSlotId());
        ActivitySlotDO parentActivitySlot = this.activitySlotDAO.getBySlotId(req.getParentSlotId());
        List<ActivitySortDto> parentActivitySortParam = this.activitySortDAO.getAllActivityBySlotId(req.getParentSlotId());
        if (CollectionUtils.isEmpty(parentActivitySortParam)) {
            throw new TuiaMediaException(ErrorCode.E0501006);
        }
        ArrayList<ReqIdAndType> idAndTypeList = new ArrayList<ReqIdAndType>();
        for (ActivitySortDto dto : parentActivitySortParam) {
            ReqIdAndType reqIdAndType = new ReqIdAndType();
            reqIdAndType.setId(dto.getActivityId());
            reqIdAndType.setSource(dto.getSource());
            reqIdAndType.setType(dto.getActivityType());
            idAndTypeList.add(reqIdAndType);
        }
        if (childActivitySlot != null) {
            List<ActivitySortDto> childActivitySortParam = this.activitySortDAO.getAllActivityBySlotId(req.getChildSlotId());
            if (CollectionUtils.isNotEmpty(childActivitySortParam)) {
                this.addActivitySlot(req, parentActivitySlot, childActivitySlot);
                this.activitySortService.addActivitySort(req.getChildSlotId(), idAndTypeList);
            } else if (CollectionUtils.isEmpty(childActivitySortParam)) {
                this.addActivitySlot(req, parentActivitySlot, childActivitySlot);
                this.activitySortService.addActivitySort(req.getChildSlotId(), idAndTypeList);
            }
        } else if (this.addActivitySlot(req, parentActivitySlot, childActivitySlot)) {
            this.activitySortService.addActivitySort(req.getChildSlotId(), idAndTypeList);
        }
        return true;
    }

    private boolean addActivitySlot(ReqCopySlot req, ActivitySlotDO parentActivitySlotParam, ActivitySlotDO childActivitySlotParam) throws TuiaMediaException {
        if (childActivitySlotParam == null) {
            ActivitySlotDO activitySlot = new ActivitySlotDO();
            activitySlot.setSlotId(req.getChildSlotId());
            activitySlot.setDirectMode(parentActivitySlotParam.getDirectMode());
            return this.activitySlotDAO.insertActivitySlot(activitySlot) > 0;
        }
        return this.activitySlotDAO.update(childActivitySlotParam.getSlotId(), parentActivitySlotParam.getDirectMode()) > 0;
    }
}

