/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.media.service.impl;

import cn.com.duiba.tuia.media.api.dto.SlotCacheDto;
import cn.com.duiba.tuia.media.api.dto.SlotDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySort;
import cn.com.duiba.tuia.media.api.dto.req.ReqIdAndType;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivityDto;
import cn.com.duiba.tuia.media.common.constants.ErrorCode;
import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.dao.ActivityDAO;
import cn.com.duiba.tuia.media.dao.ActivitySortDAO;
import cn.com.duiba.tuia.media.dataobject.ActivitySlotDO;
import cn.com.duiba.tuia.media.dataobject.MediaAppActivityDO;
import cn.com.duiba.tuia.media.domain.ActivityDto;
import cn.com.duiba.tuia.media.domain.ActivitySortDto;
import cn.com.duiba.tuia.media.parser.ActivityDtoParser;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.tuia.media.service.ActivitySlotService;
import cn.com.duiba.tuia.media.service.ActivitySortService;
import cn.com.duiba.tuia.media.service.SlotService;
import cn.com.duiba.tuia.media.service.cacheservice.ActivityDirectAppCacheService;
import cn.com.duiba.tuia.media.service.impl.SlotCacheService;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.CollectionUtils;
import org.springframework.util.StringUtils;

@Service
public class ActivitySortServiceImpl
implements ActivitySortService {
    protected Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ActivitySortDAO activitySortDAO;
    @Autowired
    private SlotService slotService;
    @Autowired
    private ActivityService activityService;
    @Autowired
    private ActivitySlotService activitySlotService;
    @Autowired
    private ActivityDAO activityDAO;
    @Autowired
    private SlotCacheService slotCacheService;
    @Autowired
    private ActivityDirectAppCacheService activityDirectAppCacheService;

    @Override
    public List<ActivitySortDto> selectByCondition(ReqActivitySort reqActivitySort) throws TuiaMediaException {
        if (!StringUtils.isEmpty((Object)reqActivitySort.getName())) {
            List<Long> list = this.activityService.getIdsByName(reqActivitySort.getName());
            if (CollectionUtils.isEmpty(list)) {
                return new ArrayList<ActivitySortDto>();
            }
            reqActivitySort.setActivityIds(list);
        }
        return this.activitySortDAO.selectByCondition(reqActivitySort);
    }

    @Override
    public int selectByConditionAmount(ReqActivitySort reqActivitySort) throws TuiaMediaException {
        if (!StringUtils.isEmpty((Object)reqActivitySort.getName())) {
            List<Long> list = this.activityService.getIdsByName(reqActivitySort.getName());
            if (CollectionUtils.isEmpty(list)) {
                return 0;
            }
            reqActivitySort.setActivityIds(list);
        }
        return this.activitySortDAO.selectByConditionAmount(reqActivitySort);
    }

    @Override
    @Transactional
    public boolean deleteActivity(Long activityId, Integer activityType, Long slotId) throws TuiaMediaException {
        if (activityId == null || activityType == null) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        ReqActivitySort reqActivitySort = new ReqActivitySort();
        reqActivitySort.setSlotId(slotId);
        List<ActivitySortDto> activitySortList = this.selectByCondition(reqActivitySort);
        int location = 0;
        for (ActivitySortDto activitySortDto : activitySortList) {
            if (!activitySortDto.getActivityId().equals(activityId) || !activitySortDto.getActivityType().equals(activityType)) continue;
            location = activitySortDto.getAbsoluteSort();
        }
        this.activitySortDAO.deleteActivity(slotId, activityId, activityType);
        this.activitySortDAO.updateSortBatch(slotId, location, activitySortList.get(activitySortList.size() - 1).getAbsoluteSort(), -1);
        return true;
    }

    @Override
    @Transactional
    public boolean deleteActivityBySource(Long activityId, Integer source, Long slotId) throws TuiaMediaException {
        if (activityId == null || source == null) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        ReqActivitySort reqActivitySort = new ReqActivitySort();
        reqActivitySort.setSlotId(slotId);
        List<ActivitySortDto> activitySortList = this.selectByCondition(reqActivitySort);
        int location = 0;
        for (ActivitySortDto activitySortDto : activitySortList) {
            if (!activitySortDto.getActivityId().equals(activityId) || !activitySortDto.getSource().equals(source)) continue;
            location = activitySortDto.getAbsoluteSort();
        }
        this.activitySortDAO.deleteActivityBySource(slotId, activityId, source);
        this.activitySortDAO.updateSortBatch(slotId, location, activitySortList.get(activitySortList.size() - 1).getAbsoluteSort(), -1);
        return true;
    }

    @Override
    public List<RspActivityDto> getActivityForRecommendByApp(Long appId) throws TuiaMediaException {
        if (appId == null) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        List<ActivitySortDto> sortList = this.activitySortDAO.getActivityForRecommendByApp(appId);
        ArrayList<RspActivityDto> result = new ArrayList<RspActivityDto>();
        for (ActivitySortDto activitySortDto : sortList) {
            RspActivityDto rspActivityDto = this.activityService.getActivityPlanDetailBySource(activitySortDto.getActivityId(), activitySortDto.getSource());
            result.add(rspActivityDto);
        }
        return result;
    }

    private List<ActivitySortDto> getActivityBySlot(Long slotId) throws TuiaMediaException {
        ActivitySlotDO activitySlot = this.activitySlotService.getBySlotId(slotId);
        if (activitySlot == null) {
            return Collections.emptyList();
        }
        return this.activitySortDAO.getActivityForRecommendBySlot(slotId);
    }

    private boolean availableMediaApp(Long appId, RspActivityDto activity) throws TuiaMediaException {
        if (activity == null || appId == null) {
            return false;
        }
        if (1 == activity.getIsDirectMedia()) {
            List<Long> directMediaApp = this.activityDirectAppCacheService.getBySource(activity.getId(), activity.getSource());
            if (CollectionUtils.isEmpty(directMediaApp)) {
                return true;
            }
            return directMediaApp.contains(appId);
        }
        return true;
    }

    private boolean availableMediaApp(Long appId, RspActivityDto activity, Map<String, List<Long>> directMap) throws TuiaMediaException {
        if (activity == null || appId == null) {
            return false;
        }
        if (1 == activity.getIsDirectMedia()) {
            String key = activity.getId() + "-" + activity.getSource();
            List<Long> directMediaApp = directMap.get(key);
            if (CollectionUtils.isEmpty(directMediaApp)) {
                return true;
            }
            return directMediaApp.contains(appId);
        }
        return true;
    }

    @Override
    public List<RspActivityDto> getActivityForRecommendBySlot(Long slotId) throws TuiaMediaException {
        if (slotId == null) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        try {
            SlotDto slot = this.slotService.selectById(slotId);
            if (slot == null) {
                this.logger.error("Not found slot, slotId=" + slotId);
                throw new TuiaMediaException(ErrorCode.E0001005);
            }
            List<ActivitySortDto> sortList = this.getActivityBySlot(slotId);
            ArrayList<RspActivityDto> result = new ArrayList<RspActivityDto>();
            for (ActivitySortDto activitySortDto : sortList) {
                RspActivityDto rspActivityDto = this.activityService.getActivityPlanDetailBySource(activitySortDto.getActivityId(), activitySortDto.getSource());
                if (rspActivityDto == null || rspActivityDto.getActivityStatus() != 1 || rspActivityDto.getIsEnable() != 1 || rspActivityDto.getIsPublish() != 1) continue;
                if (slot.getSlotType() == 9 && rspActivityDto.getMsIdList() != null && rspActivityDto.getMsIdList().contains(slot.getSlotMsId())) {
                    if (!this.availableMediaApp(slot.getAppId(), rspActivityDto)) continue;
                    result.add(rspActivityDto);
                    continue;
                }
                if (slot.getSlotType() == 8 || slot.getSlotType() == 9 || !this.availableMediaApp(slot.getAppId(), rspActivityDto)) continue;
                result.add(rspActivityDto);
            }
            return result;
        }
        catch (Exception e) {
            this.logger.error("ActivitySortService.getActivityForRecommendBySlot is error");
            throw new TuiaMediaException(ErrorCode.E9999999, (Throwable)e);
        }
    }

    @Override
    public int addActivitySort(Long slotId, List<ReqIdAndType> idAndTypes) {
        try {
            ReqActivitySort reqActivitySort = new ReqActivitySort();
            reqActivitySort.setSlotId(slotId);
            List<ActivitySortDto> existList = this.selectByCondition(reqActivitySort);
            HashSet<String> existActivity = new HashSet<String>(existList.size());
            for (ActivitySortDto activitySortDto : existList) {
                existActivity.add("-ACTIVITY-SOURCE-" + activitySortDto.getActivityId() + "-" + activitySortDto.getSource());
            }
            int sort = existList.size() == 0 ? 1 : existList.get(existList.size() - 1).getAbsoluteSort() + 1;
            ArrayList<ActivitySortDto> activitySortDtoList = new ArrayList<ActivitySortDto>();
            SlotDto slotDto = null;
            if (!slotId.equals(0L)) {
                slotDto = this.slotService.selectById(slotId);
            }
            for (ReqIdAndType idAndType : idAndTypes) {
                if (slotDto != null) {
                    RspActivityDto rspActivityDto = this.activityService.getActivityPlanDetailBySource(idAndType.getId(), idAndType.getSource());
                    if (!this.availableMediaApp(slotDto.getAppId(), rspActivityDto)) continue;
                }
                ReqIdAndType reqIdAndType = new ReqIdAndType();
                reqIdAndType.setId(idAndType.getId());
                reqIdAndType.setSource(idAndType.getSource());
                if (existActivity.contains("-ACTIVITY-SOURCE-" + reqIdAndType.getId() + "-" + reqIdAndType.getSource())) continue;
                ActivitySortDto activitySortDto = new ActivitySortDto();
                activitySortDto.setActivitySlotId(slotId);
                activitySortDto.setActivityId(idAndType.getId());
                activitySortDto.setActivityType(idAndType.getType());
                activitySortDto.setAbsoluteSort(sort);
                activitySortDto.setSource(idAndType.getSource());
                activitySortDtoList.add(activitySortDto);
                ++sort;
            }
            if (!activitySortDtoList.isEmpty()) {
                return this.activitySortDAO.insertBatch(activitySortDtoList);
            }
            return 0;
        }
        catch (Exception e) {
            this.logger.error("ActivitySortService.addActivitySort is error", (Throwable)e);
            return 0;
        }
    }

    @Override
    public int addDefaultActivitySort(Long slotId) {
        try {
            ArrayList<ReqIdAndType> idAndTypes = new ArrayList<ReqIdAndType>();
            ReqActivitySort condition = new ReqActivitySort();
            condition.setSlotId(Long.valueOf(0L));
            List<ActivitySortDto> needList = this.selectByCondition(condition);
            for (ActivitySortDto activitySortDto : needList) {
                ReqIdAndType idAndType = new ReqIdAndType();
                idAndType.setId(activitySortDto.getActivityId());
                idAndType.setType(activitySortDto.getActivityType());
                idAndType.setSource(activitySortDto.getSource());
                idAndTypes.add(idAndType);
            }
            return this.addActivitySort(slotId, idAndTypes);
        }
        catch (Exception e) {
            this.logger.error("ActivitySortService.addDefaultActivitySort is error", (Throwable)e);
            return 0;
        }
    }

    @Override
    @Transactional
    public boolean sortActivity(Long slotId, Long activityId, Integer activityType, int destLocation) throws TuiaMediaException {
        if (slotId == null || activityId == null || activityType == null || destLocation <= 0) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        ReqActivitySort reqActivitySort = new ReqActivitySort();
        reqActivitySort.setSlotId(slotId);
        List<ActivitySortDto> activitySortList = this.selectByCondition(reqActivitySort);
        if (destLocation > activitySortList.size()) {
            throw new TuiaMediaException(ErrorCode.E0501002);
        }
        int originalLoc = 0;
        for (int i = 0; i < activitySortList.size(); ++i) {
            if (!activitySortList.get(i).getActivityId().equals(activityId) || !activitySortList.get(i).getActivityType().equals(activityType)) continue;
            originalLoc = i + 1;
            break;
        }
        if (originalLoc == 0) {
            throw new TuiaMediaException(null, String.format("\u6d3b\u52a8[%s]\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5b9a\u5236\u5217\u8868", activityId));
        }
        if (originalLoc < destLocation) {
            this.activitySortDAO.updateSortBatch(slotId, originalLoc + 1, destLocation, -1);
        } else if (originalLoc > destLocation) {
            this.activitySortDAO.updateSortBatch(slotId, destLocation, originalLoc, 1);
        }
        this.activitySortDAO.updateSort(slotId, activityId, activityType, destLocation);
        return true;
    }

    @Override
    public boolean sortActivityBySource(Long slotId, Long activityId, Integer source, int destLocation) throws TuiaMediaException {
        if (slotId == null || activityId == null || source == null || destLocation <= 0) {
            throw new TuiaMediaException(ErrorCode.E0001005);
        }
        ReqActivitySort reqActivitySort = new ReqActivitySort();
        reqActivitySort.setSlotId(slotId);
        List<ActivitySortDto> activitySortList = this.selectByCondition(reqActivitySort);
        if (destLocation > activitySortList.size()) {
            throw new TuiaMediaException(ErrorCode.E0501002);
        }
        int originalLoc = 0;
        for (int i = 0; i < activitySortList.size(); ++i) {
            if (!activitySortList.get(i).getActivityId().equals(activityId) || !activitySortList.get(i).getSource().equals(source)) continue;
            originalLoc = i + 1;
            break;
        }
        if (originalLoc == 0) {
            throw new TuiaMediaException(null, String.format("\u6d3b\u52a8[%s]\u5df2\u88ab\u5220\u9664\uff0c\u8bf7\u5237\u65b0\u5b9a\u5236\u5217\u8868", activityId));
        }
        if (originalLoc < destLocation) {
            this.activitySortDAO.updateSortBatch(slotId, originalLoc + 1, destLocation, -1);
        } else if (originalLoc > destLocation) {
            this.activitySortDAO.updateSortBatch(slotId, destLocation, originalLoc, 1);
        }
        this.activitySortDAO.updateSortBySource(slotId, activityId, source, destLocation);
        return true;
    }

    @Override
    public List<RspActivityDto> getActivityForCenter(Long slotId) throws TuiaMediaException {
        List<ActivitySortDto> activitySortList = this.activitySortDAO.getActivityForRecommendBySlot(0L);
        ArrayList activitySortIds = Lists.newArrayList();
        ArrayList activitySortSources = Lists.newArrayList();
        if (!CollectionUtils.isEmpty(activitySortList)) {
            for (ActivitySortDto activitySortDto : activitySortList) {
                activitySortIds.add(activitySortDto.getActivityId());
                activitySortSources.add(activitySortDto.getSource());
            }
        }
        List<RspActivityDto> rspActivityDtos = this.activityService.getActivityPlanDetail4ListBySource(activitySortIds, activitySortSources);
        HashMap repMap = Maps.newHashMap();
        for (RspActivityDto dto : rspActivityDtos) {
            String key = dto.getId() + "-" + dto.getSource();
            repMap.put(key, dto);
        }
        SlotCacheDto slotCacheDto = this.slotCacheService.getSlot(slotId);
        List<MediaAppActivityDO> mediaAppActivityDOs = this.activityDirectAppCacheService.get4ListBySources(activitySortIds, activitySortSources);
        HashMap directMap = Maps.newHashMap();
        for (MediaAppActivityDO mediaAppActivityDO : mediaAppActivityDOs) {
            String key = mediaAppActivityDO.getActivityId() + "-" + mediaAppActivityDO.getSource();
            ArrayList<Long> ids = (ArrayList<Long>)directMap.get(key);
            if (ids == null) {
                ids = new ArrayList<Long>();
            }
            ids.add(mediaAppActivityDO.getMediaAppId());
            directMap.put(key, ids);
        }
        ArrayList<RspActivityDto> rspActivityList = new ArrayList<RspActivityDto>();
        for (ActivitySortDto activitySortDto : activitySortList) {
            String key = activitySortDto.getActivityId() + "-" + activitySortDto.getSource();
            RspActivityDto activityDto = (RspActivityDto)repMap.get(key);
            if (((RspActivityDto)repMap.get(key)).getSource() != 0 || !this.availableMediaApp(slotCacheDto == null ? null : slotCacheDto.getAppId(), activityDto, directMap)) continue;
            rspActivityList.add(activityDto);
        }
        return rspActivityList;
    }

    @Override
    public List<RspActivityDto> getEngineActivityList() throws TuiaMediaException {
        List<ActivityDto> list = this.activityDAO.selectEngineActivityList();
        ArrayList<RspActivityDto> result = new ArrayList<RspActivityDto>();
        if (!CollectionUtils.isEmpty(list)) {
            for (ActivityDto activity : list) {
                result.add(ActivityDtoParser.parseToRspActivityDto(activity));
            }
        }
        return result;
    }

    @Override
    public List<RspActivityDto> getNewActivityList() throws TuiaMediaException {
        List<ActivityDto> list = this.activityDAO.selectNewActivityList();
        ArrayList<RspActivityDto> result = new ArrayList<RspActivityDto>();
        if (!CollectionUtils.isEmpty(list)) {
            for (ActivityDto activity : list) {
                result.add(ActivityDtoParser.parseToRspActivityDto(activity));
            }
        }
        return result;
    }

    @Override
    public List<RspActivityDto> getDefaultActivityList() throws TuiaMediaException {
        List<ActivitySortDto> activitySortList = this.activitySortDAO.getActivityForRecommendBySlot(0L);
        ArrayList<RspActivityDto> rspActivityList = new ArrayList<RspActivityDto>();
        if (!CollectionUtils.isEmpty(activitySortList)) {
            for (ActivitySortDto activitySortDto : activitySortList) {
                RspActivityDto rspActivityDto = new RspActivityDto();
                rspActivityDto.setId(activitySortDto.getActivityId());
                rspActivityDto.setType(activitySortDto.getActivityType());
                rspActivityDto.setSource(activitySortDto.getSource());
                rspActivityList.add(rspActivityDto);
            }
        }
        return rspActivityList;
    }

    @Override
    public List<ActivitySortDto> getBySlot(Long slotId) throws TuiaMediaException {
        return this.activitySortDAO.selectBySlot(slotId);
    }

    @Override
    public Boolean updateSort(Long slotId, Long activityId, Integer activityType, int sort) throws TuiaMediaException {
        return this.activitySortDAO.updateSort(slotId, activityId, activityType, sort) > 1;
    }

    @Override
    public Boolean updateSortBySource(Long slotId, Long activityId, Integer source, int sort) throws TuiaMediaException {
        return this.activitySortDAO.updateSortBySource(slotId, activityId, source, sort) > 1;
    }

    @Override
    public List<Long> getActivityBySource(Integer source, Integer num) throws TuiaMediaException {
        if (num == null || num <= 0) {
            new ArrayList();
        }
        if (num > 20) {
            num = 20;
        }
        return this.activitySortDAO.getActivityBySource(source, num);
    }
}

