/**
 * Project Name:media-deploy File Name:SlotStatisticsController.java Package Name:cn.com.duiba.tuia.media.web.controller
 * Date:2016年10月10日下午3:46:26 Copyright (c) 2016, duiba.com.cn All Rights Reserved.
 */

package cn.com.duiba.tuia.media.web.controller;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;

import javax.validation.Valid;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindingResult;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

import cn.com.duiba.tuia.media.common.exception.TuiaMediaException;
import cn.com.duiba.tuia.media.api.dto.PageResultDto;
import cn.com.duiba.tuia.media.api.dto.req.ReqSlotLineStatisticsByPageDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspSlotLineStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspMediaAppDataStatisticsDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspSlotDataStatisticsDto;
import cn.com.duiba.tuia.media.bo.SlotLineStatisticsBO;
import cn.com.duiba.tuia.media.model.Result;
import cn.com.duiba.tuia.media.utils.RequestLocal;

/**
 * ClassName:SlotStatisticsController <br/>
 * Function: 结算数据统计. <br/>
 * Date: 2016年10月10日 下午3:46:26 <br/>
 * 
 * @author guyan
 * @version
 * @since JDK 1.6
 * @see
 */
@Controller
@RequestMapping("/slotLineStatistics")
@Api("结算数据统计")
public class SlotLineStatisticsController extends BaseController {

    @Autowired
    private SlotLineStatisticsBO slotLineStatisticsBo;

    /**
     * 
     * getStatisticsDataByDate:(根据开始和结束日期获取相关统计数据). <br/>
     *
     * @author ZFZ
     * @param param
     * @param result
     * @return
     * @since JDK 1.6
     */
    @ResponseBody
    @ApiOperation(value = "获取折线统计数据", httpMethod = "GET", notes = "获取折线统计数据接口")
    @RequestMapping(value = "getStatisticsDataByDate", method = RequestMethod.GET)
    public Result<RspSlotLineStatisticsDto> getStatisticsDataByDate(@Valid @ModelAttribute @RequestBody ReqSlotLineStatisticsByPageDto param,
                                                                    BindingResult result) {
        try {
            checkParam(result);
            param.setMediaId(RequestLocal.get().getCid());
            return successResult(this.slotLineStatisticsBo.selectStatisticsDataByDate(param));
        } catch (TuiaMediaException e) {
            logger.info("DataStatisticsController.getStatisticsDataByDate error! the param=[{}]",param);
            return failResult(e);
        }
    }

    /**
     * 
     * getMediaAppData:(获取媒体app统计数据). <br/>
     *
     * @author ZFZ
     * @param param
     * @param result
     * @return
     * @since JDK 1.6
     */
    @ResponseBody
    @ApiOperation(value = "获取媒体app统计数据", httpMethod = "GET", notes = "获取媒体app统计数据接口")
    @RequestMapping(value = "getMediaAppData", method = RequestMethod.GET)
    public Result<PageResultDto<RspMediaAppDataStatisticsDto>> getMediaAppData(@Valid @ModelAttribute @RequestBody ReqSlotLineStatisticsByPageDto param,
                                                                               BindingResult result) {
        try {
            checkParam(result);
            param.setMediaId(RequestLocal.get().getCid());
            return successResult(this.slotLineStatisticsBo.getMediaAppStatisticsData(param));
        } catch (TuiaMediaException e) {
            logger.info("DataStatisticsController.getMediaAppData error! the param=[{}]",param);
            return failResult(e);
        }
    }

    /**
     * 
     * getSlotData:(获取广告位统计数据). <br/>
     *
     * @author ZFZ
     * @param param
     * @param result
     * @return
     * @since JDK 1.6
     */
    @ResponseBody
    @ApiOperation(value = "获取广告位统计数据", httpMethod = "GET", notes = "获取广告位统计数据接口")
    @RequestMapping(value = "getSlotData", method = RequestMethod.GET)
    public Result<PageResultDto<RspSlotDataStatisticsDto>> getSlotData(@Valid @ModelAttribute @RequestBody ReqSlotLineStatisticsByPageDto param,
                                                                       BindingResult result) {
        try {
            checkParam(result);
            param.setMediaId(RequestLocal.get().getCid());
            return successResult(this.slotLineStatisticsBo.getSlotStatisticsData(param));
        } catch (TuiaMediaException e) {
            logger.info("DataStatisticsController.getSlotData error! the param=[{}]",param);
            return failResult(e);
        }
    }

}
