/**
 * Project Name:media-deploy<br>
 * File Name:TestController.java<br>
 * Package Name:cn.com.duiba.tuia.media.web.controller<br>
 * Date:2016年12月28日下午4:48:21<br>
 * Copyright (c) 2016, duiba.com.cn All Rights Reserved.<br>
 */
package cn.com.duiba.tuia.media.web.controller;

import cn.com.duiba.tuia.media.api.dto.req.ReqActivitySlotDto;
import cn.com.duiba.tuia.media.api.dto.rsp.RspActivitySlotDto;
import cn.com.duiba.tuia.media.domain.ActivitySortDto;
import cn.com.duiba.tuia.media.service.AccountService;
import cn.com.duiba.tuia.media.service.ActivityService;
import cn.com.duiba.tuia.media.service.ActivitySlotService;
import cn.com.duiba.tuia.media.service.ActivitySortService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiOperation;

import java.util.List;

import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import cn.com.duiba.tuia.media.model.Result;
import cn.com.duiba.tuia.media.service.StrategyService;
import cn.com.duiba.tuia.media.service.impl.MediaCacheService;
import cn.com.duiba.tuia.media.service.impl.SlotCacheService;
import cn.com.duiba.tuia.media.utils.StringTool;

import com.alibaba.dubbo.common.utils.StringUtils;

/**
 * ClassName: TestController <br/>
 * Function: 获取缓存. <br/>
 * date: 2016年12月28日 下午4:48:21 <br/>
 *
 * @author xiawei
 * @version
 * @since JDK 1.6
 */
@Controller
@RequestMapping("/test")
@Api("获取缓存相关api")
public class TestController extends BaseController {

    @Autowired
    private MediaCacheService   mediaCacheService;

    @Autowired
    private SlotCacheService    slotCacheService;

    @Autowired
    private ActivityService     activityService;

    @Autowired
    private StrategyService     strategyService;

    @Autowired
    private ActivitySlotService activitySlotService;

    @Autowired
    private ActivitySortService activitySortService;

    @Autowired
    private AccountService      accountService;

    /**
     * getAppNameById:(获取媒体名称缓存). <br/>
     *
     * @author ZFZ
     * @param appId
     * @return
     * @since JDK 1.6
     */
    @ResponseBody
    @ApiOperation(value = "获取媒体名称缓存", httpMethod = "GET", notes = "获取媒体名称缓存接口")
    @RequestMapping(value = "/getAppNameById", method = RequestMethod.GET)
    @ApiImplicitParam(name = "appId", value = "媒体应用ID", required = true, dataType = "Long", paramType = "query")
    public Result<String> getAppNameById(Long appId) {
        try {
            // 参数校验
            return successResult(mediaCacheService.getAppNameByIdKey(appId));
        } catch (Exception e) {
            logger.error("TestController.getAppNameById error!,the appId=[{}]", appId);
            return failResult(e);
        }
    }

    /**
     * getSlotNameById:(获取广告名称缓存). <br/>
     *
     * @author ZFZ
     * @param slotId
     * @return
     * @since JDK 1.6
     */
    @ResponseBody
    @ApiOperation(value = "获取广告名称缓存", httpMethod = "GET", notes = "获取广告名称缓存接口")
    @RequestMapping(value = "/getSlotNameById", method = RequestMethod.GET)
    @ApiImplicitParam(name = "slotId", value = "广告ID", required = true, dataType = "Long", paramType = "query")
    public Result<String> getSlotNameById(Long slotId) {
        try {
            return successResult(slotCacheService.getSlotNameCacheById(slotId));
        } catch (Exception e) {
            logger.error("TestController.getSlotNameById error!,the slotId=[{}]", slotId);
            return failResult(e);
        }
    }

    /**
     * 清除屏蔽策略缓存.
     *
     * @param ids the ids
     * @return the result< boolean>
     */
    @ResponseBody
    @RequestMapping(value = "/cleanStrategyCache", method = RequestMethod.GET)
    public Result<Boolean> cleanStrategyCache(@RequestParam String ids) {
        try {
            List<Long> strategyIds;
            if (StringUtils.isBlank(ids)) {
                // 查询所有屏蔽策略
                strategyIds = strategyService.selectAllIds();
            } else {
                strategyIds = StringTool.getLongListByStr(ids);
            }

            // 清除缓存
            logger.info("cleanStrategyCache begin!,the strategyIds=[{}]", strategyIds);
            if (CollectionUtils.isNotEmpty(strategyIds)) {
                for (Long strategyId : strategyIds) {
                    slotCacheService.deleteStrategyCache(strategyId);
                }
            }
            return successResult();
        } catch (Exception e) {
            logger.error("TestController.cleanStrategyCache error!,the slotId=[{}]", ids);
            return failResult(e);
        }
    }

    /**
     * delAllAppCache:(删除媒体信息缓存). <br/>
     *
     * @return
     * @since JDK 1.6
     */
    @ResponseBody
    @ApiOperation(value = "删除媒体信息缓存", httpMethod = "POST", notes = "删除媒体信息缓存")
    @RequestMapping(value = "/delAllAppCache", method = RequestMethod.POST)
    public Result<Boolean> delAllAppCache() {
        try {
            return successResult(mediaCacheService.delAllAppCache());
        } catch (Exception e) {
            logger.error("TestController.delAllAppCache error");
            return failResult(e);
        }
    }

    /**
     * getAllAppCache:(获取媒体信息缓存). <br/>
     *
     * @return
     * @since JDK 1.6
     */
    @ResponseBody
    @ApiOperation(value = "初始化媒体信息缓存", httpMethod = "GET", notes = "初始化媒体信息缓存")
    @RequestMapping(value = "/initAllAppCache", method = RequestMethod.GET)
    public Result<Boolean> initAllAppCache() {
        try {
            return successResult(mediaCacheService.initAllAppCache());
        } catch (Exception e) {
            logger.error("TestController.initAllAppCache error");
            return failResult(e);
        }
    }

    /**
     * delAllAccountCache:(删除所有媒体用户信息缓存). <br/>
     *
     * @return
     * @since JDK 1.6
     */
    @ResponseBody
    @ApiOperation(value = "删除所有媒体用户信息缓存", httpMethod = "POST", notes = "删除所有媒体用户信息缓存")
    @RequestMapping(value = "/delAllAccountCache", method = RequestMethod.POST)
    public Result<Boolean> delAllAccountCache() {
        try {
            return successResult(mediaCacheService.delAllAccountCache());
        } catch (Exception e) {
            logger.error("TestController.delAllAccountCache error");
            return failResult(e);
        }
    }

    /**
     * initAllAccountCache:(初始化所有媒体用户信息缓存). <br/>
     *
     * @author ZFZ
     * @return
     * @since JDK 1.6
     */
    @ResponseBody
    @ApiOperation(value = "初始化所有媒体用户信息缓存", httpMethod = "GET", notes = "初始化所有媒体用户信息缓存")
    @RequestMapping(value = "/initAllAccountCache", method = RequestMethod.GET)
    public Result<Boolean> initAllAccountCache() {
        try {
            return successResult(mediaCacheService.initAllAccountCache());
        } catch (Exception e) {
            logger.error("TestController.initAllAccountCache error");
            return failResult(e);
        }
    }

    /**
     * refreshAllRedisActivity:(刷新所有活动缓存). <br/>
     *
     * @author ZFZ
     * @param password
     * @return
     * @since JDK 1.6
     */
    @ResponseBody
    @ApiOperation(value = "刷新所有活动缓存", httpMethod = "GET", notes = "刷新所有活动缓存")
    @RequestMapping(value = "/refreshAllRedisActivity", method = RequestMethod.GET)
    public Result<Boolean> refreshAllRedisActivity(@RequestParam String password) {
        try {
            if (!"abc123".equals(password)) {
                return successResult(false);
            }
            return successResult(mediaCacheService.refreshAllRedisActivity());
        } catch (Exception e) {
            logger.error("TestController.refreshAllRedisActivity error");
            return failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value = "刷新所有appName和Id缓存", httpMethod = "GET", notes = "刷新所有appName和Id缓存")
    @RequestMapping(value = "/refreshAllAppNameAndId", method = RequestMethod.GET)
    public Result<Boolean> refreshAllAppNameAndId() {
        try {
            return successResult(mediaCacheService.getAppIdAndNameCache());
        } catch (Exception e) {
            logger.error("TestController.refreshAllAppNameAndId error");
            return failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value = "将所有开启活动加入到手动投放列表", httpMethod = "GET", notes = "将所有开启活动加入到手动投放列表")
    @RequestMapping(value = "/addActivityToManualList", method = RequestMethod.GET)
    public Result<Boolean> addActivityToManualList(@RequestParam String password) {
        try {
            if (!"abc123".equals(password)) {
                return successResult(false);
            }
            return successResult(activityService.addActivityToManualList());
        } catch (Exception e) {
            logger.error("TestController.addActivityToManualList error");
            return failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value = "更新活动绝对排序字段值", httpMethod = "GET", notes = "更新活动绝对排序字段值")
    @RequestMapping(value = "/updateActivitySort", method = RequestMethod.GET)
    public Result<Boolean> updateActivitySort(@RequestParam String password) {
        try {
            if (!"abc123".equals(password)) {
                return successResult(false);
            }
            ReqActivitySlotDto reqActivitySlotDto = new ReqActivitySlotDto();
            reqActivitySlotDto.setPageSize(10000);
            reqActivitySlotDto.setCurrentPage(1);
            List<RspActivitySlotDto> activitySlotList = activitySlotService.getList(reqActivitySlotDto);
            for (RspActivitySlotDto activitySlotDto : activitySlotList) {
                List<ActivitySortDto> activitySortList = activitySortService.getBySlot(activitySlotDto.getSlotId());
                if (CollectionUtils.isNotEmpty(activitySortList)) {
                    for (int i = 0; i < activitySortList.size(); i++) {
                        ActivitySortDto activitySortDto = activitySortList.get(i);
                        activitySortService.updateSort(activitySlotDto.getSlotId(), activitySortDto.getActivityId(),
                                                       activitySortDto.getActivityType(), i + 1);
                    }
                }
            }
            List<ActivitySortDto> activitySortList = activitySortService.getBySlot(0L);
            if (CollectionUtils.isNotEmpty(activitySortList)) {
                for (int i = 0; i < activitySortList.size(); i++) {
                    ActivitySortDto activitySortDto = activitySortList.get(i);
                    activitySortService.updateSort(0L, activitySortDto.getActivityId(),
                                                   activitySortDto.getActivityType(), i + 1);
                }
            }
            return successResult(true);
        } catch (Exception e) {
            logger.error("TestController.updateActivitySort error");
            return failResult(e);
        }
    }

    @ResponseBody
    @ApiOperation(value = "修改邮箱激活状态", httpMethod = "POST", notes = "修改邮箱激活状态")
    @RequestMapping(value = "/updateEmailStatus", method = RequestMethod.POST)
    public Result<Boolean> updateEmailStatus(@RequestParam String email) {
        try {
            return successResult(accountService.manualUpdateEmailStatus(email));
        } catch (Exception e) {
            logger.error("TestController.updateEmailStatus error");
            return failResult(e);
        }

    }
    
    /**
     * refreshAllRedisActivityDirectApp:(刷新所有广告位定制活动缓存). <br/>
     *
     * @author SJX
     * @param password
     * @return
     * @since JDK 1.6
     */
    @ResponseBody
    @ApiOperation(value = "刷新所有广告位定制活动缓存", httpMethod = "GET", notes = "刷新所有广告位定制活动缓存")
    @RequestMapping(value = "/refreshAllRedisActivityDirectApp", method = RequestMethod.GET)
    public Result<Boolean> refreshAllRedisActivityDirectApp(@RequestParam Long activityId,@RequestParam Integer source) {
        try {
            return successResult(mediaCacheService.refreshAllRedisActivityDirectApp(activityId,source));
        } catch (Exception e) {
            logger.error("TestController.updateEmailStatus error");
            return failResult(e);
        }

    }

}
