package cn.com.duiba.tuia.news.center.dto;

import java.io.Serializable;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: UserDto.java , v 0.1 2017/12/28 下午2:40 ZhouFeng Exp $
 */
public class UserDto implements Serializable {

    /**
     * 用户ID
     */
    private Long userId;

    private String token;

    /**
     * 是否为新用户
     */
    private Boolean newUser;

    private UserDto(Builder builder) {
        setUserId(builder.userId);
        setToken(builder.token);
        setNewUser(builder.newUser);
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public String getToken() {
        return token;
    }

    public void setToken(String token) {
        this.token = token;
    }

    public Boolean getNewUser() {
        return newUser;
    }

    public void setNewUser(Boolean newUser) {
        this.newUser = newUser;
    }


    public static final class Builder {
        private Long userId;
        private String token;
        private Boolean newUser;

        public Builder() {
        }

        public Builder userId(Long val) {
            userId = val;
            return this;
        }

        public Builder token(String val) {
            token = val;
            return this;
        }

        public Builder newUser(Boolean val) {
            newUser = val;
            return this;
        }

        public UserDto build() {
            return new UserDto(this);
        }
    }
}
