package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.AddActivityDto;
import cn.com.duiba.tuia.news.center.dto.NewsActivityDto;
import cn.com.duiba.tuia.news.center.dto.Response.NewsActivityResponse;
import cn.com.duiba.tuia.news.center.dto.UpdateActivityDto;
import cn.com.duiba.tuia.news.center.enums.ActivityValidStatus;

import java.util.List;

@AdvancedFeignClient
public interface RemoteNewsActivityService {

    /**
     * 过期方法,下个版本删除</br>
     * 添加活动
     *
     * @param dto 添加的dto
     * @return 添加结果 true-成功 false-失败
     */
    @Deprecated
    Boolean addActivity(NewsActivityDto dto);

    /**
     * 过期方法,下个版本删除</br>
     * 删除活动
     * 
     * @param id 活动id
     * @return 删除结果 true-成功 false-失败
     */
    @Deprecated
    Boolean deleteByPrimaryKey(Long id);

    /**
     * 过期方法,下个版本删除</br>
     * 更新活动信息,更新的内容有:名称,图片,活动链接,活动来源
     *
     * @param dto 更新的dto
     * @return 更新结果 true-成功 false-失败
     */
    @Deprecated
    Boolean updateActivity(NewsActivityDto dto);

    /**
     * 添加活动
     *
     * @param addDto 添加的dto
     * @return 添加结果 true-成功 false-失败
     */
    Boolean add(AddActivityDto addDto);

    /**
     * 删除活动,软删除,将删除状态置为1
     *
     * @param id 活动id
     * @return 删除结果 true-成功 false-失败
     */
    Boolean delete(Long id);

    /**
     * 获取所有可用活动
     * 
     * @return 所有可用活动列表
     */
    List<NewsActivityDto> ListAll();

    NewsActivityResponse query(NewsActivityDto dto);

    /**
     * 更新活动信息,更新的内容有:名称,图片,活动链接,活动来源
     * 
     * @param dto 更新的dto
     * @return 更新结果 true-成功 false-失败
     */
    Boolean updateBaseInfo(UpdateActivityDto dto);

    /**
     * 更新启用状态
     * 
     * @param id 活动的id
     * @param validStatus 状态
     * @return 更新结果 true-成功 false-失败
     */
    Boolean updateValidStatus(Long id, ActivityValidStatus validStatus);

    /**
     * 更新排序状态
     *
     * @param id 活动的id
     * @param sortNum 排序值
     * @return 更新结果 true-成功 false-失败
     */
    Boolean updateSortNumber(Long id, Integer sortNum);

}
