package cn.com.duiba.tuia.news.center.enums;

public enum RewardTaskType {

                            READING_NEWS(1L, "阅读文章"),

                            LOGIN(2L, "登录奖励"),


    ;

    private Long   taskId;
    private String taskDescription;

    RewardTaskType(Long taskId, String taskDescription) {
        this.taskId = taskId;
        this.taskDescription = taskDescription;
    }

    public Long getTaskId() {
        return taskId;
    }

    public String getTaskDescription() {
        return taskDescription;
    }

    public static RewardTaskType getByTaskId(Long taskId) {
        for (RewardTaskType taskType : RewardTaskType.values()) {
            if (taskType.taskId.equals(taskId)) {
                return taskType;
            }
        }
        throw new RuntimeException("任务不存在");
    }
}
