package cn.com.duiba.tuia.news.center.enums;

/**
 * 审核状态
 *
 * @author ElinZhou
 * @version $Id: ApplyStatus.java , v 0.1 2018/1/2 下午3:50 ElinZhou Exp $
 */
public enum ApplyStatus {
    /**
     * 申请中
     */
    PROCESS(0),

    /**
     * 通过
     */
    PASS(1),

    /**
     * 拒绝
     */
    REJECT(2),


    ;


    private Integer code;

    ApplyStatus(Integer code) {
        this.code = code;
    }

    public Integer getCode() {
        return code;
    }

    public boolean same(Integer other) {
        if (other == null) {
            return false;
        }
        return code.equals(other);
    }

    public static ApplyStatus of(Integer aCode) {
        if (aCode == null) {
            return null;
        }
        for (ApplyStatus applyStatus : values()) {
            if (applyStatus.getCode().equals(aCode)) {
                return applyStatus;
            }
        }
        return null;
    }

}
