package cn.com.duiba.tuia.news.center.enums;

/**
 * @author ElinZhou
 * @version $Id: WithdrawChannelType.java , v 0.1 2018/1/2 下午5:56 ElinZhou Exp $
 */
public enum WithdrawChannelType {

    /**
     * 支付宝人工
     */
    ALIPAY_MANUAL(1),


    ;


    private Integer code;

    WithdrawChannelType(Integer code) {
        this.code = code;
    }

    public Integer getCode() {
        return code;
    }

    public static WithdrawChannelType of(Integer aCode) {
        if (aCode == null) {
            return null;
        }
        for (WithdrawChannelType withdrawChannelType : values()) {
            if (withdrawChannelType.getCode().equals(aCode)) {
                return withdrawChannelType;
            }
        }
        return null;
    }

    public boolean same(Integer other) {
        if (other == null) {
            return false;
        }
        return code.equals(other);

    }
}
