package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.BaseQueryDto;
import cn.com.duiba.tuia.news.center.dto.NewsExchangeDto;
import cn.com.duiba.tuia.news.center.dto.Response.NewsExchangeResponse;

import java.math.BigDecimal;
import java.util.Date;

@AdvancedFeignClient
public interface RemoteNewsExchangeService {

    NewsExchangeResponse query(BaseQueryDto dto);

    @Deprecated
    Boolean addNewsExchange(NewsExchangeDto newsExchangeDto);

    @Deprecated
    Boolean updateNewsExchange(NewsExchangeDto newsExchangeDto) throws BizException;

    Boolean execute(long id, String operator) throws BizException;

    /**
     * 新增分成比例
     *
     * @param date
     * @param divideRate 请将例如10%转换为0.1传入此项
     * @return
     */
    void addDevideRate(Date date, BigDecimal divideRate, String operator) throws BizException;


    /**
     * 更新分成比例
     *
     * @param date
     * @param divideRate
     * @return
     * @throws BizException
     */
    void updateDeviceRate(Date date, BigDecimal divideRate, String operator) throws BizException;

}
