package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.req.SignInResultDto;
import cn.com.duiba.tuia.news.center.dto.rsp.ReadingTaskCompleteDto;
import cn.com.duiba.tuia.news.center.dto.RewardTaskCompleteDto;
import cn.com.duiba.tuia.news.center.dto.RewardTaskDto;

import java.util.List;
import java.util.Map;

/**
 * @author ElinZhou
 * @version $Id: RemoteRewardTaskService.java , v 0.1 2018/1/3 上午11:41 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteRewardTaskService {

    /**
     * 完成任务(3月14号发布后可以删除该接口)
     *
     * @param userId 用户id
     * @param item   兑换项id，例如文章id
     * @return
     */
    @Deprecated
    RewardTaskCompleteDto complete(Long userId, Long taskId, String item) throws BizException;

    /**
     * 任务领取次数是否达到上限(3月14号发布后可以删除该接口)
     *
     * @param userId 用户id
     * @param taskId 任务id
     * @return
     */
    @Deprecated
    Boolean isUpperLimit(Long userId, Long taskId);

    /**
     * 查询任务ids(3月14号发布后可以删除该接口)
     *
     * @param taskIds
     * @return
     */
    @Deprecated
    Map<Long, RewardTaskDto> queryTaskByIds(List<Long> taskIds);

    /**
     * 完成阅读
     * @param userId 用户id
     * @param newsId 新闻id
     * @return 完成阅读任务返回
     */
    ReadingTaskCompleteDto readingComplete(Long userId, String newsId) throws BizException;


    /**
     * 判断该用户是否完成今日阅读任务(今日阅读奖励全部获得)
     * @param userId 用户id
     * @return 完成情况 true-全部完成 false-未完成
     */
    Boolean isTodayReadingTaskDone(Long userId);

    /**
     * 该篇新闻是否有阅读奖励
     * @param userId 用户id
     * @param newsId 新闻id
     * @return true-有 false-无
     */
    Boolean hasReadingReward(Long userId,String newsId);

    /**
     * 签到
     * @param userId 用户id
     * @return 签到结果
     */
    SignInResultDto signIn(Long userId) throws BizException;


}
