/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums;

import cn.com.duiba.tuia.news.center.enums.Reward;
import java.util.Random;
import java.util.stream.Stream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface RandomReward
extends Reward {
    public static final Logger LOGGER = LoggerFactory.getLogger(RandomReward.class);

    public static RandomReward getReward(RandomReward[] randomRewards) {
        int totalRate = Stream.of(randomRewards).mapToInt(RandomReward::getRate).sum();
        int randomNumber = new Random().nextInt(totalRate) + 1;
        int last = 0;
        for (RandomReward randomReward : randomRewards) {
            if (randomNumber > last && randomNumber <= last + randomReward.getRate()) {
                return randomReward;
            }
            last += randomReward.getRate().intValue();
        }
        throw new RuntimeException("\u4e0d\u5b58\u5728\u7684\u5956\u9879");
    }

    @Override
    default public Long getRewardFee() {
        return (long)new Random().nextInt(this.getMax().intValue() - this.getMin().intValue() + 1) + this.getMin();
    }

    public Long getMin();

    public Long getMax();

    public Integer getRate();
}

