package cn.com.duiba.tuia.news.center.enums;

/**
 * @author ElinZhou
 * @version $Id: ErrorCode.java , v 0.1 2017/12/28 下午3:24 ElinZhou Exp $
 */
public enum ErrorCode {

                       ACCOUNT_EXCEPTION("0300001", "账号异常"),

                       NOT_SUPPORT_LOGIN_TYPE("0300001", "不支持的登录类型"),

                       INVALID_TOKEN("0300002", "无效token"),

                       ORDER_NOT_EXIST("0300003", "流水不存在"),

                       LACK_OF_CHANGE_BALANCE("0300004", "零钱余额不足"),

                       LACK_OF_COIN_BALANCE("0300005", "金币余额不足"),

                       REWARD_TASK_NOT_EXIST("0300006", "奖励任务不存在"),

                       OVER_TASK_MAX_LIMIT_TIMES("0300007", "超过任务可领取次数上限"),

                       ARTICLE_ALREADY_READED("0300008", "该任务对象已领取"),

                       USER_NOT_EXIST("0300009", "用户不存在"),

                       EXCHANGE_RATE_DUPLICATE("0300010", "汇率日期重复"),

                       EXCHANGE_INVALID_STATUS("0300011", "汇率状态异常"),

                       PARAM_NULL("0300012", "请求参数为空"),

                       OVER_SIGN_IN_LIMIT("0300013", "今日已完成签到"),

                       ALREADY_BE_INVITED("0300014", "您已经输入过邀请码"),

                       INVITE_CODE_NOT_EXIST("0300015", "邀请码不存在"),

                       OLD_USER_CAN_NOT_WRITE_INVITE_CODE("0300016", "老用户无法输入邀请码"),

                       CAN_NOT_WRITE_SELF_INVITE_CODE("0300018", "请勿输入自己的邀请码"),

    ;

    private String code;

    private String description;

    ErrorCode(String code, String description) {
        this.code = code;
        this.description = description;
    }

    public String getCode() {
        return code;
    }

    public String getDescription() {
        return description;
    }

}
