package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;

import static cn.com.duiba.tuia.news.center.enums.RewardUnit.COIN;

public enum OldUserSignInReward implements SignInReward {
                                                   DAY_ONE(1, 10L, COIN),

                                                   DAY_TWO(2, 15L, COIN),

                                                   DAY_THREE(3, 20L, COIN),

                                                   DAY_FOUR(4, 25L, COIN),

                                                   DAY_FIVE(5, 30L, COIN),

                                                   DAY_SIX(6, 35L, COIN),

                                                   DAY_SEVEN(7, 40L, COIN);

    private Integer    day;
    private Long       rewardFee;
    private RewardUnit rewardUnit;
    private static final Map<Integer, OldUserSignInReward> CACHE = Maps.uniqueIndex(Arrays.asList(OldUserSignInReward
            .values()), OldUserSignInReward::getDay);

    OldUserSignInReward(Integer day, Long rewardFee, RewardUnit rewardUnit) {
        this.day = day;
        this.rewardFee = rewardFee;
        this.rewardUnit = rewardUnit;
    }

    @Override
    public Integer getDay() {
        return day;
    }

    @Override
    public Long getRewardFee() {
        return rewardFee;
    }

    @Override
    public RewardUnit getRewardUnit() {
        return rewardUnit;
    }

    public static OldUserSignInReward getByDay(Integer day) {
        return Optional.ofNullable(CACHE.get(day)).orElseThrow(() -> new RuntimeException("签到异常"));
    }
}
