package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.LoginDto;
import cn.com.duiba.tuia.news.center.dto.UserDto;
import cn.com.duiba.tuia.news.center.dto.UserInfoDto;
import cn.com.duiba.tuia.news.center.enums.UserLoginType;

/**
 * @author ElinZhou
 * @version $Id: RemoteUserService.java , v 0.1 2017/12/28 下午2:36 ElinZhou Exp $
 */
@AdvancedFeignClient
public interface RemoteUserService {


    /**
     * 登录
     *
     * @param loginUser 登录用户信息
     * @param loginType 登录方式
     * @return
     */
    UserDto login(LoginDto loginUser, UserLoginType loginType) throws BizException;

    /**
     * 登录
     *
     * @param loginUser 登录用户信息
     * @param loginType 登录方式
     * @return
     */
    UserDto login110(LoginDto loginUser, UserLoginType loginType) throws BizException;

    /**
     * 登录
     *
     * @param loginUser 登录用户信息
     * @param loginType 登录方式
     * @return
     */
    UserDto login120(LoginDto loginUser, UserLoginType loginType) throws BizException;


    /**
     * token 转换为userId
     *
     * @param token
     * @return userId
     * @throws BizException
     */
    Long tokenExchange(String token) throws BizException;

    /**
     * 获取邀请码
     * 
     * @param userId 用户 id
     * @return 邀请码
     */
    String getInviteCode(Long userId) throws BizException;

    /**
     * 根据用户 id 获取用户信息
     * 
     * @param userId 用户 id
     * @return 用户信息
     */
    UserInfoDto getUserInfo(Long userId);

}
