package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.math.BigDecimal;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Random;

import static cn.com.duiba.tuia.news.center.enums.RewardUnit.CHANGE;
import static cn.com.duiba.tuia.news.center.enums.RewardUnit.COIN;

public enum NewUserSignInReward implements SignInReward {

                                                         DAY_ONE(1, 0L, CHANGE),

                                                         DAY_TWO(2, 2L, CHANGE),

                                                         DAY_THREE(3, 1L, CHANGE),

                                                         DAY_FOUR(4, 1L, CHANGE),

                                                         DAY_FIVE(5, 2L, CHANGE),

                                                         DAY_SIX(6, 1L, CHANGE),

                                                         DAY_SEVEN(7, 3L, CHANGE);

    private Integer             day;
    private Long                rewardFee;
    private RewardUnit          rewardUnit;

    private static final Map<Integer, NewUserSignInReward> CACHE = Maps.uniqueIndex(Arrays.asList(NewUserSignInReward
            .values()), NewUserSignInReward::getDay);

    NewUserSignInReward(Integer day, Long rewardFee, RewardUnit rewardUnit) {
        this.day = day;
        this.rewardFee = rewardFee;
        this.rewardUnit = rewardUnit;
    }

    @Override
    public Long getRewardFee() {
        switch (rewardFee.intValue()){
            case 0:// 0则说明是现金奖励在(0.1,0.3]之间
                Integer reward0 = new Random().nextInt(20) + 11;
                return reward0.longValue();
            case 1:// -1则说明是现金奖励在(0,0.2]之间
                Integer reward1 = new Random().nextInt(20) + 1;
                return reward1.longValue();
            case 2://调用新的概率分布奖励枚举
                RandomReward loginRewardSignInReward = RandomReward.getReward(LoginRewardSignInReward.values());
                return loginRewardSignInReward.getRewardFee();
            case 3:
                Integer reward3 = new Random().nextInt(30) + 20;
                return reward3.longValue();
            default:
                return 0L;
        }
    }

    @Override
    public Integer getDay() {
        return day;
    }

    @Override
    public RewardUnit getRewardUnit() {
        return rewardUnit;
    }

    public static NewUserSignInReward getByDay(Integer day) {
        return Optional.ofNullable(CACHE.get(day)).orElseThrow(() -> new RuntimeException("签到异常"));
    }
}
