package cn.com.duiba.tuia.news.center.enums;

/**
 * 登录奖品
 */
public interface SignInReward extends Reward {

    static SignInReward get(Boolean newUser, Integer day) {
        return newUser ? NewUserSignInReward.getByDay(day) : OldUserSignInReward.getByDay(day);
    }

    static SignInReward[] get(Boolean newUser) {
        return newUser ? NewUserSignInReward.values() : OldUserSignInReward.values();
    }

    /**
     * 获取登录天数
     * 
     * @return 登录天数
     */
    Integer getDay();
}
