package cn.com.duiba.tuia.news.center.remoteservice;

import java.util.List;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.MenuDto;

@AdvancedFeignClient
public interface RemoteMenuService {

    /**
     * 获取菜单列表(已经分好层级关系)
     * @return  菜单聊表
     */
    List<MenuDto> getMenuList();

    /**
     * 编辑菜单文案
     * @param id 菜单 id
     * @param menuText 菜单文案
     * @return 编辑结果 true-成功 false-失败
     */
    Boolean edit(Long id, String menuText);

    /**
     * 获取所有菜单列表(未分级)
     * @return 菜单列表
     */
    List<MenuDto> getAllMenuList();


}
