package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

/**
 * 审核状态
 *
 * @author ElinZhou
 * @version $Id: ApplyStatus.java , v 0.1 2018/1/2 下午3:50 ElinZhou Exp $
 */
public enum WithdrawTicketEnum {
    /**
     * 1元
     */
    ONE(100L,1,"1元"),

    /**
     * 10元
     */
    TEN(1000L,0,"10元"),

    /**
     * 15元
     */
    FIFTEEN(1500L,0,"15元"),

    /**
     * 50元
     */
    FIFTY(5000L,0,"50元"),

    ;
    private static final Map<Long, WithdrawTicketEnum> CACHE = Maps.uniqueIndex(Arrays.asList(WithdrawTicketEnum
            .values()), WithdrawTicketEnum::getCode);

    private Long fee;
    //0:非特权券  1：特权券
    private Integer type;
    private String desc;

    WithdrawTicketEnum(Long fee, Integer type, String desc) {
        this.fee = fee;
        this.type = type;
        this.desc = desc;
    }

    public String getDesc() {
        return desc;
    }

    public Long getCode() {
        return fee;
    }

    public Integer getType() {
        return type;
    }

    public static WithdrawTicketEnum of(Integer aCode) {
        return CACHE.get(aCode);
    }

}
