package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;

@AdvancedFeignClient
public interface RemoteUserSignInService {
    /**
     * 获取登录签到完成轮数
     * @param userId 用户 id
     * @return 获取完整签到轮数
     */
    Integer getRounds(Long userId);

    /**
     * 获取连续签到天数
     * @param userId 用户 id
     * @return 连续签到天数
     */
    Integer getContinueDays(Long userId);

    /**
     * 判断该用户是否处于新用户签到周期
     * @param userId 用户 id
     * @return true-是 false-否
     */
    Boolean newUser(Long userId);
}
