package cn.com.duiba.tuia.news.center.dto;

import cn.com.duiba.tuia.news.center.enums.ApplyStatus;
import cn.com.duiba.tuia.news.center.enums.WithdrawChannelType;
import cn.com.duiba.tuia.news.center.enums.WithdrawStatus;
import cn.com.duiba.tuia.news.center.enums.WithdrawType;

import java.io.Serializable;
import java.util.Date;

/**
 * @author ZhouFeng zhoufeng@duiba.com.cn
 * @version $Id: WithdrawOrderDto.java , v 0.1 2018/1/3 上午11:25 ZhouFeng Exp $
 */
public class WithdrawOrderDto implements Serializable {

    private static final long serialVersionUID = 295340883275701303L;
    /**
     * 提现流水号
     */
    private Long serialNumber;

    /**
     * 零钱流水号
     */
    private Long changeSerialNumber;

    /**
     * 提现金额
     */
    private Long fee;

    /**
     * 用户id
     */
    private Long userId;

    /**
     * 提现渠道
     */
    private WithdrawChannelType channel;

    /**
     * 提现类型
     */
    private WithdrawType withdrawType;

    /**
     * 收款人姓名
     */
    private String payeeName;

    /**
     * 收款人账号
     */
    private String payeeAccount;

    /**
     * 收款备注
     */
    private String payeeRemark;

    /**
     * 提现状态
     */
    private ApplyStatus withdrawStatus;

    /**
     * 创建时间
     */
    private Date gmtCreate;

    /**
     * 更新时间
     */
    private Date gmtModified;
    /**
     * Alipay转账状态
     */
    private WithdrawStatus alipayWithdrawStatus;

    /**
     * alipay返回信息

     */
    private String alipayFallBack;

    /**
     * 驳回原因
     */
    private String turnDownNote;

    /**
     * 特权券Id

     */
    private Long ticketId;

    public String getTurnDownNote() {
        return turnDownNote;
    }

    public void setTurnDownNote(String turnDownNote) {
        this.turnDownNote = turnDownNote;
    }

    public Long getTicketId() {
        return ticketId;
    }

    public void setTicketId(Long ticketId) {
        this.ticketId = ticketId;
    }

    public WithdrawStatus getAlipayWithdrawStatus() {
        return alipayWithdrawStatus;
    }

    public void setAlipayWithdrawStatus(WithdrawStatus alipayWithdrawStatus) {
        this.alipayWithdrawStatus = alipayWithdrawStatus;
    }

    public String getAlipayFallBack() {
        return alipayFallBack;
    }

    public void setAlipayFallBack(String alipayFallBack) {
        this.alipayFallBack = alipayFallBack;
    }

    public Long getSerialNumber() {
        return serialNumber;
    }

    public void setSerialNumber(Long serialNumber) {
        this.serialNumber = serialNumber;
    }

    public Long getChangeSerialNumber() {
        return changeSerialNumber;
    }

    public void setChangeSerialNumber(Long changeSerialNumber) {
        this.changeSerialNumber = changeSerialNumber;
    }

    public Long getFee() {
        return fee;
    }

    public void setFee(Long fee) {
        this.fee = fee;
    }

    public Long getUserId() {
        return userId;
    }

    public void setUserId(Long userId) {
        this.userId = userId;
    }

    public WithdrawChannelType getChannel() {
        return channel;
    }

    public void setChannel(WithdrawChannelType channel) {
        this.channel = channel;
    }

    public WithdrawType getWithdrawType() {
        return withdrawType;
    }

    public void setWithdrawType(WithdrawType withdrawType) {
        this.withdrawType = withdrawType;
    }

    public String getPayeeName() {
        return payeeName;
    }

    public void setPayeeName(String payeeName) {
        this.payeeName = payeeName;
    }

    public String getPayeeAccount() {
        return payeeAccount;
    }

    public void setPayeeAccount(String payeeAccount) {
        this.payeeAccount = payeeAccount;
    }

    public String getPayeeRemark() {
        return payeeRemark;
    }

    public void setPayeeRemark(String payeeRemark) {
        this.payeeRemark = payeeRemark;
    }

    public ApplyStatus getWithdrawStatus() {
        return withdrawStatus;
    }

    public void setWithdrawStatus(ApplyStatus withdrawStatus) {
        this.withdrawStatus = withdrawStatus;
    }

    public Date getGmtCreate() {
        return gmtCreate;
    }

    public void setGmtCreate(Date gmtCreate) {
        this.gmtCreate = gmtCreate;
    }

    public Date getGmtModified() {
        return gmtModified;
    }

    public void setGmtModified(Date gmtModified) {
        this.gmtModified = gmtModified;
    }
}
