package cn.com.duiba.tuia.news.center.enums;

import java.util.Arrays;
import java.util.Map;

import com.google.common.collect.Maps;

public enum RewardTaskType {

                            READING_NEWS(1L, "阅读文章"),

                            SIGN_IN(2L, "每日登录"),

                            COMPENSATE(3L, "用户补偿"),

                            WATCH_VIDEO(4L, "观看视频"),

                            INVITE_READ(5L, "好友阅读"),

                            BIND_INVITE_CODE(6L, "绑定邀请码"),

    ;

    private Long   taskId;
    private String taskDescription;

    private static final Map<Long, RewardTaskType> CACHE = Maps.uniqueIndex(Arrays.asList(RewardTaskType.values()),
            RewardTaskType::getTaskId);

    RewardTaskType(Long taskId, String taskDescription) {
        this.taskId = taskId;
        this.taskDescription = taskDescription;
    }

    public Long getTaskId() {
        return taskId;
    }

    public String getTaskDescription() {
        return taskDescription;
    }

    public static RewardTaskType getByTaskId(Long taskId) {
        RewardTaskType rewardTaskType = CACHE.get(taskId);
        if (rewardTaskType != null) {
            return rewardTaskType;
        }
        return null;
    }
}
