package cn.com.duiba.tuia.news.center.enums;

/**
 * 登录奖品
 */
public interface SignInReward extends Reward {

    static SignInReward getV2(Boolean newUser, Integer day) {
        return newUser ? NewUserSignInRewardV2.getByDay(day) : OldUserSignInRewardV2.getByDay(day);
    }
    static SignInReward[] get(Boolean newUser) {
        return newUser ? NewUserSignInReward.values() : OldUserSignInReward.values();
    }
    static SignInReward[] getV2(Boolean newUser) {
        return newUser ? NewUserSignInRewardV2.values() : OldUserSignInRewardV2.values();
    }
    static SignInReward get(Boolean newUser, Integer day){
        return newUser ? NewUserSignInReward.getByDay(day) : OldUserSignInReward.getByDay(day);
    }

    /**
     * 根据天数获取当天最高的奖励
     * @param day
     * @return
     */
    static Long getTopReward(Boolean newUser , Integer day){
        return newUser ? NewUserSignInRewardV2.getTopReward(day) : OldUserSignInRewardV2.getTopReward(day);
    }

    /**
     * 获取登录天数
     * 
     * @return 登录天数
     */
    Integer getDay();
}
