/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;

public enum RewardTaskType {
    READING_NEWS(1L, "\u9605\u8bfb\u6587\u7ae0"),
    SIGN_IN(2L, "\u6bcf\u65e5\u767b\u5f55"),
    COMPENSATE(3L, "\u7528\u6237\u8865\u507f"),
    WATCH_VIDEO(4L, "\u89c2\u770b\u89c6\u9891"),
    INVITE_READ(5L, "\u597d\u53cb\u9605\u8bfb"),
    BIND_INVITE_CODE(6L, "\u7ed1\u5b9a\u9080\u8bf7\u7801"),
    ACCOUNT_BIND_CODE(7L, "\u8d26\u53f7\u7ed1\u5b9a");

    private Long taskId;
    private String taskDescription;
    private static final Map<Long, RewardTaskType> CACHE;

    private RewardTaskType(Long taskId, String taskDescription) {
        this.taskId = taskId;
        this.taskDescription = taskDescription;
    }

    public Long getTaskId() {
        return this.taskId;
    }

    public String getTaskDescription() {
        return this.taskDescription;
    }

    public static RewardTaskType getByTaskId(Long taskId) {
        RewardTaskType rewardTaskType = CACHE.get(taskId);
        if (rewardTaskType != null) {
            return rewardTaskType;
        }
        return null;
    }

    static {
        CACHE = Maps.uniqueIndex(Arrays.asList(RewardTaskType.values()), RewardTaskType::getTaskId);
    }
}

