package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

public enum InviteChangeRewardEnum {

                            FIVE(1, 50L),

                            TEN(2, 100L),

                            FIFTEEN(3, 150L);

    private Integer  id;
    private Long count;

    private static final Map<Long, InviteChangeRewardEnum> CACHE = Maps.uniqueIndex(Arrays.asList(InviteChangeRewardEnum.values()),
            InviteChangeRewardEnum::getCount);

    InviteChangeRewardEnum(Integer id, Long count) {
        this.id = id;
        this.count = count;
    }

    public Integer getId() {
        return id;
    }

    public Long getCount() {
        return count;
    }

    public static InviteChangeRewardEnum getByCount(Long count) {
        InviteChangeRewardEnum inviteChangeRewardEnum = CACHE.get(count);
        if (inviteChangeRewardEnum != null) {
            return inviteChangeRewardEnum;
        }
        return null;
    }

    public static InviteChangeRewardEnum getById(Integer id) {
        for (InviteChangeRewardEnum inviteChangeRewardEnum :InviteChangeRewardEnum.values()) {
            if(id.equals(inviteChangeRewardEnum.getId())){
                return inviteChangeRewardEnum;
            }
        }
        return null;
    }

    public static Long getNextReward(Long count){
        InviteChangeRewardEnum inviteChangeRewardEnum = getByCount(count);
        Integer nextId = inviteChangeRewardEnum.getId()+1;
        InviteChangeRewardEnum inviteChangeRewardEnum1 = getById(nextId);
        if(null != inviteChangeRewardEnum1){
            return inviteChangeRewardEnum1.getCount();
        }else {
            return 0L;
        }
    }
}
