package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.LandConditionDto;
import cn.com.duiba.tuia.news.center.dto.LandPacketDto;
import cn.com.duiba.tuia.news.center.dto.PickPacketDto;
import cn.com.duiba.tuia.news.center.enums.LandTaskType;

import java.util.List;

/**
 * Created by xiaotian on 2018/5/8.
 */
@AdvancedFeignClient
public interface RemoteLandService {

    /**
     * 初始化土地
     * @param userId
     * @return
     */
    boolean init(Long userId);

    /**
     * 未开垦的地绑定对应关系
     * @param userId
     * @param sort
     * @param landTaskId
     * @return
     */
    List<Integer> binding(Long userId, Integer sort, Integer landTaskId) throws BizException;


    /**
     * 将待开垦土地置成已开状态
     * @param userId
     * @param sort
     * @return
     */
    boolean digLand(Long userId,Integer sort) throws BizException;


    /**
     * 获取土地状况（附加土地上的红包的种植情况和成熟情况）
     */
    List<LandConditionDto> getLandCondition(Long userId) throws BizException;

    /**
            * 种植
     * @param userId
     * @param LandId
     * @return
             */
    LandPacketDto plant(Long userId, Long LandId) throws BizException;

    /**
     * 摘取红包
     * @param userId
     * @param landId
     * @return
     */
    PickPacketDto pick(Long userId, Long landId) throws BizException;



}
