package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.AgentAccountDto;
import cn.com.duiba.tuia.news.center.dto.SubAccountDetailDto;
import cn.com.duiba.tuia.news.center.dto.SubAccountDetailResultDto;
import cn.com.duiba.tuia.news.center.dto.req.MediaAccountStatusDto;
import cn.com.duiba.tuia.news.center.dto.req.AgentAccountQueryDto;
import cn.com.duiba.tuia.news.center.dto.req.PageQueryResultDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteAgentAccountService {

    /**
     * 根据Id查询代理
     * @param id
     * @return
     */
    AgentAccountDto selectById(Long id);


    /**
     * 分页查询代理账号
     * @param agentAccountQueryDto
     * @return
     */
    PageQueryResultDto<AgentAccountDto> selectList(AgentAccountQueryDto agentAccountQueryDto);

    /**
     * 批量更新代理状态
     * @return
     */
    Boolean batchUpdateAgentStatus(MediaAccountStatusDto mediaAccountStatusDto);

    /**
     * 新增、更新代理信息
     * @param agentAccountDto
     * @return
     */
    Boolean save(AgentAccountDto agentAccountDto);

    /**
     * 更新代理状态
     * @param mediaAccountStatusDto
     * @return
     */
    Boolean updateAgentStatus(MediaAccountStatusDto mediaAccountStatusDto);

    /**
     *根据账号右模糊查询代理列表
     * @return
     */
    List<AgentAccountDto> selectListLikeAccountName(String accountName);


    /**
     * 分页查询子账号详情
     * @return
     */
    SubAccountDetailResultDto<SubAccountDetailDto>  selectSubAccountDetail(AgentAccountQueryDto agentAccountQueryDto);

    /**
     * 根据账号准确查询账号
     * @return
     */
    boolean selectByAccount(String account);

    /**
     * 根据ids查询代理账号
     * @param ids
     * @return
     */
    List<AgentAccountDto>  selectByIds(List<Long> ids);
}
