package cn.com.duiba.tuia.news.center.enums;

import java.util.Arrays;
import java.util.Map;

import com.google.common.collect.Maps;

/**
 * 零钱收入码
 *
 * @author ElinZhou
 * @version $Id: ChangeIncomeCode.java , v 0.1 2017/12/30 下午6:48 ElinZhou Exp $
 */
public enum ChangeIncomeCode  implements ChangeTradeCode{

                                                         /**
                                                          * 结算
                                                          */
                                                         SETTLE(1, "金币兑换现金"),

                                                         /**
                                                          * 新用户奖励
                                                          */
                                                         NEW_USER_REWARD(2, "新用户奖励"),

                                                         /**
                                                          * 登录奖励
                                                          */
                                                         SIGN_IN(3, "登录奖励"),

                                                         /**
                                                          * 提现驳回
                                                          */
                                                         WITHDRAW_TURN_DOWN(4, "提现退还入账"),

                                                         /**
                                                          *
                                                          */
                                                         INVITE_INCOME(5,"邀请好友"),

                                                         /**
                                                          *
                                                         */
                                                         LIMIT_PECKET(6,"限时红包"),

                                                        /**
                                                         *
                                                         */
                                                        NEW_TICKET_WITHDRAW(7,"一元提现奖励返回")

    ;

    private static final Map<Integer, ChangeIncomeCode> CACHE = Maps.uniqueIndex(Arrays.asList(ChangeIncomeCode.values()),
                                                                                 ChangeIncomeCode::getCode);

    private Integer code;

    private String                                      desc;

    ChangeIncomeCode(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }


    @Override
    public Integer getCode() {
        return code;
    }

    @Override
    public String getDesc() {
        return desc;
    }

    public static ChangeIncomeCode get(Integer code) {
        return CACHE.get(code);
    }
}
