package cn.com.duiba.tuia.news.center.enums;


import java.util.Random;

public enum LimitOperateRewardEnum{
    SELF_1(72L, 73L),

    SELF_2(72L, 73L),

    OTHER_1(18L, 18L),

    OTHER_2(8L, 8L);

    private Long min;
    private Long max;

    LimitOperateRewardEnum(Long min, Long max) {
        this.min = min;
        this.max = max;
    }

    public Long getMin() {
        return min;
    }


    public Long getMax() {
        return max;
    }

    /**
     * 获取红包帮助百分比
     * @param limitOperateRewardEnum
     * @return
     */
    public static Long getProbability(LimitOperateRewardEnum limitOperateRewardEnum){
        return new Random().nextInt(limitOperateRewardEnum.getMax().intValue() - limitOperateRewardEnum.getMin().intValue() + 1)
                + limitOperateRewardEnum.getMin();
    }


}
