package cn.com.duiba.tuia.news.center.dto;

import cn.com.duiba.tuia.news.center.enums.RewardUnit;

import java.io.Serializable;

/**
 * Created by xiaotian on 2018/5/10.
 */
public class InviteRewardNewDto implements Serializable {
    /**
     * 被邀请人名称
     */
    private String name;
    /**
     * 被邀请人头像
     */
    private String inviteeImage;
    /**
     * 获取的奖励类型 1：金币 2：零钱
     */
    private Integer rewardType = RewardUnit.CHANGE.getCode();
    /**
     * 奖励数量
     */
    private Long rewardCount = 0L;
    /**
     * 待唤醒状态 true:待唤醒 false：非待唤醒
     */
    private boolean waitawaken;
    /**
     * 唤醒将获取的奖励数量
     */
    private Long wakeRewardCount = 0L;
    /**
     * 唤醒将获取的奖励类型
     */
    private Integer wakeRewardType;

    /**
     * 邀请人Id
     */
    private Long inviterId;
    /**
     * 被邀请人Id
     */
    private Long inviteeId;

    public Long getWakeRewardCount() {
        return wakeRewardCount;
    }

    public void setWakeRewardCount(Long wakeRewardCount) {
        this.wakeRewardCount = wakeRewardCount;
    }

    public Integer getWakeRewardType() {
        return wakeRewardType;
    }

    public void setWakeRewardType(Integer wakeRewardType) {
        this.wakeRewardType = wakeRewardType;
    }

    public String getInviteeImage() {
        return inviteeImage;
    }

    public void setInviteeImage(String inviteeImage) {
        this.inviteeImage = inviteeImage;
    }

    public Long getInviterId() {
        return inviterId;
    }

    public void setInviterId(Long inviterId) {
        this.inviterId = inviterId;
    }

    public Long getInviteeId() {
        return inviteeId;
    }

    public void setInviteeId(Long inviteeId) {
        this.inviteeId = inviteeId;
    }

    public boolean isWaitawaken() {
        return waitawaken;
    }

    public void setWaitawaken(boolean waitawaken) {
        this.waitawaken = waitawaken;
    }


    public String getName() {
        return name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Integer getRewardType() {
        return rewardType;
    }

    public void setRewardType(Integer rewardType) {
        this.rewardType = rewardType;
    }

    public Long getRewardCount() {
        return rewardCount;
    }

    public void setRewardCount(Long rewardCount) {
        this.rewardCount = rewardCount;
    }
}
