package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.exception.BizException;
import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.LimitHelpDto;
import cn.com.duiba.tuia.news.center.dto.req.LimitHelpReq;
import cn.com.duiba.tuia.news.center.dto.LimitOperateDto;
import cn.com.duiba.tuia.news.center.dto.LimitPacketConditionDto;
import cn.com.duiba.tuia.news.center.dto.LimitPacketWithdrawDto;

import java.util.List;

/**
 * Created by xiaotian on 2018/5/21.
 */
@AdvancedFeignClient
public interface RemoteLimitPacketService {


    /**
     * 开启限时红包
     * @param userId
     * @return
     */
    LimitPacketConditionDto openLimitPacket(Long userId) throws BizException;

    /**
     * 获取红包状况(当前情况下可用限时红包就一个)
     * @return
     */
    LimitPacketConditionDto limitPacketCondition(Long userId) throws BizException;

    /**
     * 获取红包的帮戳列表
     * @param limitPacketId
     * @return
     */
    List<LimitOperateDto> helpList(Long userId,Long limitPacketId);

    /**
     * 帮戳
     * @return
     */
    LimitHelpDto help(LimitHelpReq limitHelpReq) throws BizException;

    /**
     * 提取限时红包
     * @param packetId
     * @return
     */
    LimitPacketWithdrawDto withdraw(Long userId,Long packetId) throws BizException;

    /**
     * 获取红包状况（分享的前端接口）
     * @param packetId
     * @return
     */
    LimitPacketConditionDto limitPacketConditionForH5(String code,Long packetId) throws BizException;

}
