package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.req.MediaAccountTokenDto;

/**
 * Created by zhou_wb on 2018/4/12.
 */
@AdvancedFeignClient
public interface RemoteMediaAccountTokenService {

    /**
     * 根据账号Id查询token
     * @param accountId 账号Id
     * @return 账号token 对象
     */
    MediaAccountTokenDto selectByAccountId(Long accountId);

    /**
     * 根据token查询
     * @param token 登录token
     * @return 账号token 对象
     */
    MediaAccountTokenDto selectByToken(String token);

    /**
     * 新增、保存token对象
     * @param mediaAccountTokenDto token对象
     * @return token对象
     */
    MediaAccountTokenDto save(MediaAccountTokenDto mediaAccountTokenDto);
}
