package cn.com.duiba.tuia.news.center.enums;

/**
 * 金币支出码
 *
 * @author ElinZhou
 * @version $Id: CoinExpenseCode.java , v 0.1 2017/12/30 下午3:56 ElinZhou Exp $
 */
public enum CoinExpenseCode implements CoinTradeCode {

    /**
     * 金币结算
     */
    SETTLE(1, "金币结算"),

    HAOWAN_GAME(2, "好玩小游戏"),

    REFRESH_STANGER(3,"获取陌生人列表");


    private Integer code;

    private String desc;

    public Integer getCode() {
        return code;
    }

    CoinExpenseCode(Integer code, String desc) {
        this.code = code;
        this.desc = desc;
    }

    @Override
    public Long getTaskId() {
        return Long.valueOf(code);
    }

    @Override
    public String getTaskDescription() {
        return desc;
    }
}
