package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;

public enum NewLandTaskType {

                            SIGN_IN1(1, "登陆",1L),

                            SIGN_IN2(2, "登录",1L),

                            READYING_THERE(3, "阅读三篇文章",3L),

                            STEAL_NEAL_THREE(4, "偷取3个附近的人红包",3L),

                            DOG_ONE(5, "通过阅读文章获取1只看门狗",1L),

                            INVITE_ONE(6, "邀请1名好友",1L),

                            SIGNIN_FIVE(7,"连续登陆5天",5L),

                            INVITE_THREE(8,"邀请3名好友",3L),

                            THOUSAND_NEWS(9,"累积有效浏览1000篇内容",1000L),

                            INVITE_SEVEN(10,"邀请7名好友",7L),

                            READ_TIME(11,"累积阅读达到300min",300L),

                            SIGNIN_TEWENTYONE(12,"连续登录21天",21L)


    ;

    private Integer   taskId;
    private String taskDescription;
    private Long allPlan;

    private static final Map<Integer, NewLandTaskType> CACHE = Maps.uniqueIndex(Arrays.asList(NewLandTaskType.values()),
            NewLandTaskType::getTaskId);

    NewLandTaskType(Integer taskId, String taskDescription,Long allPlan) {
        this.taskId = taskId;
        this.taskDescription = taskDescription;
        this.allPlan = allPlan;
    }

    public Integer getTaskId() {
        return taskId;
    }

    public Long getAllPlan() {
        return allPlan;
    }

    public String getTaskDescription() {
        return taskDescription;
    }

    public static NewLandTaskType getByTaskId(Integer taskId) {
        NewLandTaskType rewardTaskType = CACHE.get(taskId);
        if (rewardTaskType != null) {
            return rewardTaskType;
        }
        return SIGN_IN1;
    }
}
