package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;

import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Random;

import static cn.com.duiba.tuia.news.center.enums.RewardUnit.CHANGE;
import static cn.com.duiba.tuia.news.center.enums.RewardUnit.COIN;

public enum OldUserSignInRewardV2 implements SignInReward {
                                                   DAY_ONE(1, 10L, COIN),

                                                   DAY_TWO(2, 15L, COIN),

                                                   DAY_THREE(3, 20L, COIN),

                                                   DAY_FOUR(4, 25L, COIN),

                                                   DAY_FIVE(5, 30L, COIN),

                                                   DAY_SIX(6, 35L, COIN),

                                                   DAY_SEVEN(7, -1L, CHANGE);

    private Integer    day;
    private Long       rewardFee;
    private RewardUnit rewardUnit;
    private static final Map<Integer, OldUserSignInRewardV2> CACHE = Maps.uniqueIndex(Arrays.asList(OldUserSignInRewardV2
            .values()), OldUserSignInRewardV2::getDay);

    OldUserSignInRewardV2(Integer day, Long rewardFee, RewardUnit rewardUnit) {
        this.day = day;
        this.rewardFee = rewardFee;
        this.rewardUnit = rewardUnit;
    }

    @Override
    public Integer getDay() {
        return day;
    }

    @Override
    public Long getRewardFee() {
        if((rewardFee.equals(-1L))){//第七天奖励现金默认[0.2,0.5]
            Integer reward3 = new Random().nextInt(30) + 20;
            return reward3.longValue();
        }
        return rewardFee;
    }

    @Override
    public RewardUnit getRewardUnit() {
        return rewardUnit;
    }

    public static OldUserSignInRewardV2 getByDay(Integer day) {
        return Optional.ofNullable(CACHE.get(day)).orElseThrow(() -> new RuntimeException("签到异常"));
    }
    public static Long getTopReward(Integer day) {
        OldUserSignInRewardV2 oldUserSignInReward = OldUserSignInRewardV2.getByDay(day);
        switch (oldUserSignInReward.rewardFee.intValue()){
            case -1:
                return 20000L;
            default:
                return oldUserSignInReward.rewardFee;
        }
    }
}
