package cn.com.duiba.tuia.news.center.remoteservice;

import cn.com.duiba.boot.netflix.feign.AdvancedFeignClient;
import cn.com.duiba.tuia.news.center.dto.Response.TagLibraryResponse;
import cn.com.duiba.tuia.news.center.dto.TagLibraryDto;
import cn.com.duiba.tuia.news.center.dto.TagsContentsDto;

import java.util.List;

@AdvancedFeignClient
public interface RemoteNewTagService {

    /**
     * 查询所有标签
     */
    List<TagLibraryDto> selectAll();


    /**
     * 根据内容与标签等级模糊查询标签内容 已经格式好，直接返回给前端（账号标签专用）
     * @param content 标签内容  模糊查询
     * @param tagLevel 标签等级
     * @return 标签列表 格式  List<A->B>
     */
    List<TagLibraryResponse> selectByContentAndTagLevel(String content,Integer tagLevel);

    /**
     * 根据标签Id查询标签内容
     */
    List<TagLibraryDto> selectByTagId(List<Long> tagIds);

    /**
     * 根据多个标签id拼接的字符串返回标签
     * 1.2     军事->历史
     */
    List<TagsContentsDto> selectContentsByTags(List<String> tags);


    /**
     * 根据内容与标签等级模糊查询标签内容 已经格式好，直接返回给前端(文章标签)
     * @param content 标签内容  模糊查询
     * @param tagLevel 标签等级
     * @return 标签列表 格式  List<A->B>
     */
    List<TagLibraryResponse> selectByContentAndTagLevelForArticle(String content,Integer tagLevel);

    /**
     * 根据内容由于标签等级精确查询
     * @param content 标签内容
     * @param tagLevel 标签等级
     * @return
     */
    TagLibraryDto selectOneByContent(String content,Integer tagLevel);
}
