/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;

public enum RelationType {
    FRIEND(0, "\u6fc2\u85c9\u5f38"),
    ENEMY(1, "\u6d60\u56e8\u666b"),
    STRANGER(2, "\u95c4\u5c80\u6553\u6d5c\ufffd"),
    ASSISTANT(3, "\u74d2\uff49\u6908\u704f\u5fd5\ue75d\u6d94\ufffd");

    private Integer code;
    private String description;
    private static final Map<Integer, RelationType> CACHE;

    private RelationType(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static RelationType getByCode(Integer taskId) {
        RelationType relationType = CACHE.get(taskId);
        if (relationType != null) {
            return relationType;
        }
        return FRIEND;
    }

    static {
        CACHE = Maps.uniqueIndex(Arrays.asList(RelationType.values()), RelationType::getCode);
    }
}

