/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;

public enum ApplyRelationType {
    APPLY(0, "\u9422\u5ba0\ue1ec"),
    AGREE(1, "\u935a\u5c7e\u5270"),
    REJECT(2, "\u93b7\u6394\u7cb7");

    private Integer code;
    private String description;
    private static final Map<Integer, ApplyRelationType> CACHE;

    private ApplyRelationType(Integer code, String description) {
        this.code = code;
        this.description = description;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getDescription() {
        return this.description;
    }

    public static ApplyRelationType getByCode(Integer code) {
        ApplyRelationType applyRelationType = CACHE.get(code);
        if (applyRelationType != null) {
            return applyRelationType;
        }
        return null;
    }

    static {
        CACHE = Maps.uniqueIndex(Arrays.asList(ApplyRelationType.values()), ApplyRelationType::getCode);
    }
}

