/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;

public enum WithdrawTicketEnum {
    ONE(100L, 1, "1\u934f\ufffd"),
    TEN(1000L, 0, "10\u934f\ufffd"),
    THIRTY(3000L, 0, "30\u934f\ufffd"),
    FIFTY(5000L, 0, "50\u934f\ufffd");

    private static final Map<Long, WithdrawTicketEnum> CACHE;
    private Long fee;
    private Integer type;
    private String desc;

    private WithdrawTicketEnum(Long fee, Integer type, String desc) {
        this.fee = fee;
        this.type = type;
        this.desc = desc;
    }

    public String getDesc() {
        return this.desc;
    }

    public Long getFee() {
        return this.fee;
    }

    public Integer getType() {
        return this.type;
    }

    public static WithdrawTicketEnum of(Long fee) {
        return CACHE.get(fee);
    }

    static {
        CACHE = Maps.uniqueIndex(Arrays.asList(WithdrawTicketEnum.values()), WithdrawTicketEnum::getFee);
    }
}

