/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums;

import cn.com.duiba.tuia.news.center.enums.AppVersionEnum;
import cn.com.duiba.tuia.news.center.enums.LoginRewardSignInReward;
import cn.com.duiba.tuia.news.center.enums.RandomReward;
import cn.com.duiba.tuia.news.center.enums.RewardUnit;
import cn.com.duiba.tuia.news.center.enums.SignInReward;
import com.google.common.collect.Maps;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Random;

public enum NewUserSignInRewardV2 implements SignInReward
{
    DAY_ONE(1, 0L, RewardUnit.CHANGE),
    DAY_TWO(2, 2L, RewardUnit.CHANGE),
    DAY_THREE(3, 1L, RewardUnit.CHANGE),
    DAY_FOUR(4, 1L, RewardUnit.CHANGE),
    DAY_FIVE(5, 2L, RewardUnit.CHANGE),
    DAY_SIX(6, 1L, RewardUnit.CHANGE),
    DAY_SEVEN(7, 3L, RewardUnit.CHANGE);

    private Integer day;
    private Long rewardFee;
    private RewardUnit rewardUnit;
    private static final Map<Integer, NewUserSignInRewardV2> CACHE;

    private NewUserSignInRewardV2(Integer day, Long rewardFee, RewardUnit rewardUnit) {
        this.day = day;
        this.rewardFee = rewardFee;
        this.rewardUnit = rewardUnit;
    }

    @Override
    public Long getRewardFee() {
        switch (this.rewardFee.intValue()) {
            case 0: {
                Integer reward0 = 66;
                return reward0.longValue();
            }
            case 1: {
                Integer reward1 = new Random().nextInt(20) + 1;
                return reward1.longValue();
            }
            case 2: {
                RandomReward loginRewardSignInReward = RandomReward.getReward(LoginRewardSignInReward.values());
                return loginRewardSignInReward.getRewardFee();
            }
            case 3: {
                Integer reward3 = new Random().nextInt(30) + 20;
                return reward3.longValue();
            }
        }
        return 0L;
    }

    @Override
    public Long getRewardFee(Integer version) {
        switch (this.rewardFee.intValue()) {
            case 0: {
                Integer reward0 = 66;
                if (version != null && version >= AppVersionEnum.CASH_PACKET.getVersion()) {
                    reward0 = 1588;
                }
                return reward0.longValue();
            }
            case 1: {
                Integer reward1 = new Random().nextInt(20) + 1;
                return reward1.longValue();
            }
            case 2: {
                RandomReward loginRewardSignInReward = RandomReward.getReward(LoginRewardSignInReward.values());
                return loginRewardSignInReward.getRewardFee();
            }
            case 3: {
                Integer reward3 = new Random().nextInt(30) + 20;
                return reward3.longValue();
            }
        }
        return 0L;
    }

    @Override
    public Integer getDay() {
        return this.day;
    }

    @Override
    public RewardUnit getRewardUnit() {
        return this.rewardUnit;
    }

    public static NewUserSignInRewardV2 getByDay(Integer day) {
        return Optional.ofNullable(CACHE.get(day)).orElseThrow(() -> new RuntimeException("\u7b7e\u5230\u5f02\u5e38"));
    }

    public static Long getTopReward(Integer day) {
        switch (NewUserSignInRewardV2.getByDay((Integer)day).rewardFee.intValue()) {
            case 0: {
                return 30L;
            }
            case 1: {
                return 20L;
            }
            case 2: {
                return 50L;
            }
            case 3: {
                return 20000L;
            }
        }
        return 0L;
    }

    static {
        CACHE = Maps.uniqueIndex(Arrays.asList(NewUserSignInRewardV2.values()), NewUserSignInRewardV2::getDay);
    }
}

