/*
 * Decompiled with CFR 0.152.
 */
package cn.com.duiba.tuia.news.center.enums;

import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum DailyTaskEnum {
    DAILY_SIGN(1, 0, "\u6bcf\u65e5\u7b7e\u5230"),
    READING(2, 0, "\u9605\u8bfb\u6587\u7ae0"),
    PLANT_PACKET(3, 0, "\u79cd\u690d\u7ea2\u5305"),
    LIMITED_PACKET(4, 1, "\u9650\u65f6\u7ea2\u5305"),
    INVITE_FRIEND(5, 1, "\u9080\u8bf7\u597d\u53cb"),
    GROUP_PACKET(6, 1, "\u62fc\u624b\u6c14\u7fa4\u7ea2\u5305"),
    WAKEUP_FRIEND(7, 1, "\u5524\u9192\u597d\u53cb");

    private static final List<DailyTaskEnum> BASE_TASK_LIST;
    private static final List<DailyTaskEnum> ADVANCED_TASK_LIST;
    private static final Map<Integer, DailyTaskEnum> BASE_TASK;
    private static final Map<Integer, DailyTaskEnum> ADVANCED_TASK;
    private Integer taskId;
    private Integer taskType;
    private String taskName;

    private DailyTaskEnum(Integer taskId, Integer taskType, String taskName) {
        this.taskId = taskId;
        this.taskType = taskType;
        this.taskName = taskName;
    }

    public Integer getTaskId() {
        return this.taskId;
    }

    public Integer getTaskType() {
        return this.taskType;
    }

    public String getTaskName() {
        return this.taskName;
    }

    public static List<DailyTaskEnum> getBaseTask() {
        return BASE_TASK_LIST;
    }

    public static List<DailyTaskEnum> getAdvancedTask() {
        return ADVANCED_TASK_LIST;
    }

    public static DailyTaskEnum getBaseTaskByTaskId(Integer taskId) {
        return BASE_TASK.get(taskId);
    }

    public static DailyTaskEnum getAdvancedTaskByTaskId(Integer taskId) {
        return ADVANCED_TASK.get(taskId);
    }

    static {
        BASE_TASK_LIST = Stream.of(DailyTaskEnum.values()).filter(task -> task.getTaskType().equals(0)).collect(Collectors.toList());
        ADVANCED_TASK_LIST = Stream.of(DailyTaskEnum.values()).filter(task -> task.getTaskType().equals(1)).collect(Collectors.toList());
        BASE_TASK = Maps.uniqueIndex((Iterable)Stream.of(DailyTaskEnum.values()).filter(task -> task.getTaskType().equals(0)).collect(Collectors.toList()), DailyTaskEnum::getTaskId);
        ADVANCED_TASK = Maps.uniqueIndex((Iterable)Stream.of(DailyTaskEnum.values()).filter(task -> task.getTaskType().equals(1)).collect(Collectors.toList()), DailyTaskEnum::getTaskId);
    }
}

